/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.util.AnimationPoint;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.VectorInterpolation;
import kr.toxicity.model.api.util.VectorPoint;
import kr.toxicity.model.api.util.VectorUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public record BlueprintAnimator(@NotNull String name, float length, @NotNull @Unmodifiable List<AnimationMovement> keyFrame) {
    @NotNull
    public AnimatorIterator singleIterator() {
        return new SingleIterator();
    }

    @NotNull
    public AnimatorIterator loopIterator() {
        return new LoopIterator();
    }

    private class SingleIterator
    implements AnimatorIterator {
        private int index = 0;

        private SingleIterator() {
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return BlueprintAnimator.this.keyFrame.getFirst();
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return BlueprintAnimator.this.keyFrame.size() - 1;
        }

        @Override
        public int length() {
            return Math.round(BlueprintAnimator.this.length * 100.0f);
        }

        @Override
        public void clear() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.index < BlueprintAnimator.this.keyFrame.size();
        }

        @Override
        public AnimationMovement next() {
            return BlueprintAnimator.this.keyFrame.get(this.index++);
        }
    }

    private class LoopIterator
    implements AnimatorIterator {
        private int index = 0;

        private LoopIterator() {
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return BlueprintAnimator.this.keyFrame.getFirst();
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return BlueprintAnimator.this.keyFrame.size() - 1;
        }

        @Override
        public int length() {
            return Math.round(BlueprintAnimator.this.length * 100.0f);
        }

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public AnimationMovement next() {
            if (this.index >= BlueprintAnimator.this.keyFrame.size()) {
                this.index = 0;
            }
            return BlueprintAnimator.this.keyFrame.get(this.index++);
        }
    }

    public static interface AnimatorIterator
    extends Iterator<AnimationMovement> {
        @NotNull
        public AnimationMovement first();

        public void clear();

        public int length();

        public int index();

        public int lastIndex();
    }

    public static final class Builder {
        private final float length;
        private final List<VectorPoint> transform = new ArrayList<VectorPoint>();
        private final List<VectorPoint> scale = new ArrayList<VectorPoint>();
        private final List<VectorPoint> rotation = new ArrayList<VectorPoint>();

        private static int checkSplit(float angle) {
            return (int)Math.floor(Math.toDegrees(angle) / 60.0) + 1;
        }

        @NotNull
        public Builder addFrame(@NotNull ModelKeyframe keyframe) {
            VectorInterpolation interpolation = VectorInterpolation.find(keyframe.interpolation());
            for (Datapoint dataPoint : keyframe.dataPoints()) {
                Vector3f vec = dataPoint.toVector();
                switch (keyframe.channel()) {
                    case POSITION: {
                        this.transform.add(new VectorPoint(MathUtil.transformToDisplay(vec.div(16.0f)), keyframe.time(), interpolation));
                        break;
                    }
                    case ROTATION: {
                        VectorPoint rot = new VectorPoint(MathUtil.animationToDisplay(vec), keyframe.time(), interpolation);
                        if (!this.rotation.isEmpty() && rot.time() > 0.0f) {
                            VectorPoint last = this.rotation.getLast();
                            int split = Builder.checkSplit(MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(rot.vector())).mul((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(last.vector())).invert()).angle());
                            if (split > 1) {
                                for (int i = 1; i < split; ++i) {
                                    float alpha = (float)i / (float)split;
                                    this.rotation.add(new VectorPoint(VectorUtil.linear(last.vector(), rot.vector(), alpha), VectorUtil.linear(last.time(), rot.time(), alpha), interpolation));
                                }
                            }
                        }
                        this.rotation.add(rot);
                        break;
                    }
                    case SCALE: {
                        this.scale.add(new VectorPoint(vec.sub(1.0f, 1.0f, 1.0f), keyframe.time(), interpolation));
                    }
                }
            }
            return this;
        }

        private void addLastFrame(@NotNull List<VectorPoint> points) {
            VectorPoint lastPoint;
            if (points.isEmpty()) {
                lastPoint = new VectorPoint(new Vector3f(), this.length, VectorInterpolation.LINEAR);
            } else {
                VectorPoint last = points.getLast();
                if (last.time() >= this.length) {
                    return;
                }
                lastPoint = new VectorPoint(last.vector(), this.length, last.interpolation());
            }
            points.add(lastPoint);
        }

        @NotNull
        public AnimatorData build(@NotNull String name) {
            this.addLastFrame(this.transform);
            this.addLastFrame(this.rotation);
            this.addLastFrame(this.scale);
            return new AnimatorData(name, this.length, VectorUtil.sum(this.transform.stream().distinct().toList(), this.rotation.stream().distinct().toList(), this.scale.stream().distinct().toList()));
        }

        @Generated
        public Builder(float length) {
            this.length = length;
        }
    }

    public record AnimatorData(@NotNull String name, float length, @NotNull List<AnimationPoint> points) {
    }
}

