/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.List;
import java.util.Map;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.raw.ModelData;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public record ModelBlueprint(@NotNull String name, float scale, @NotNull ModelResolution resolution, @NotNull List<BlueprintTexture> textures, @NotNull List<BlueprintChildren> group, @NotNull Map<String, BlueprintAnimation> animations) {
    @NotNull
    public static ModelBlueprint from(@NotNull String name, @NotNull ModelData data) {
        Map<String, ModelElement> elementMap = CollectionUtil.associate(data.elements(), ModelElement::uuid, e -> e);
        return new ModelBlueprint(name, data.scale(), data.resolution(), CollectionUtil.mapToList(data.textures(), BlueprintTexture::from), CollectionUtil.mapToList(data.outliner(), children -> BlueprintChildren.from(children, elementMap)), CollectionUtil.associate(data.animations().stream().map(BlueprintAnimation::from), BlueprintAnimation::name, a -> a));
    }

    @NotNull
    public @Unmodifiable List<BlueprintImage> buildImage() {
        return CollectionUtil.mapToList(this.textures, texture -> new BlueprintImage(PackUtil.toPackName(this.name + "_" + texture.name()), texture.image(), texture.isAnimatedTexture() ? texture.toMcmeta() : null));
    }
}

