/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final Parser PARSER = new Parser();

    public static final class Parser
    implements Function<JsonElement, ModelChildren>,
    JsonDeserializer<ModelChildren> {
        private Parser() {
        }

        public ModelChildren deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply(json);
        }

        @Override
        public ModelChildren apply(JsonElement element) {
            if (element.isJsonPrimitive()) {
                return new ModelUUID(element.getAsString());
            }
            if (element.isJsonObject()) {
                return (ModelChildren)ModelData.GSON.fromJson(element, ModelGroup.class);
            }
            throw new RuntimeException();
        }
    }

    public record ModelGroup(@NotNull String name, @Nullable Float3 origin, @Nullable Float3 rotation, @NotNull String uuid, @NotNull List<ModelChildren> children, @SerializedName(value="visibility") @Nullable Boolean _visibility) implements ModelChildren
    {
        @Nullable
        private final Float3 origin;
        @Nullable
        private final Float3 rotation;

        @NotNull
        public Float3 origin() {
            return this.origin != null ? this.origin : Float3.ZERO;
        }

        @NotNull
        public Float3 rotation() {
            return this.rotation != null ? this.rotation : Float3.ZERO;
        }

        public boolean visibility() {
            return !Boolean.FALSE.equals(this._visibility);
        }
    }

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
    }
}

