/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FunctionUtil {
    private FunctionUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static <T> Supplier<T> asSupplier(@NotNull T t) {
        return () -> t;
    }

    @NotNull
    public static Runnable playOnce(@NotNull Runnable runnable) {
        PlayOnceRunnable playOnceRunnable;
        return runnable instanceof PlayOnceRunnable ? (playOnceRunnable = (PlayOnceRunnable)runnable) : new PlayOnceRunnable(runnable);
    }

    @NotNull
    public static <T> Supplier<T> throttleTick(@NotNull Supplier<T> supplier) {
        return FunctionUtil.throttleTick((long)MathUtil.MINECRAFT_TICK_MILLS, supplier);
    }

    @NotNull
    public static <T> Supplier<T> throttleTick(long tick, @NotNull Supplier<T> supplier) {
        TickThrottledSupplier<T> tickThrottledSupplier;
        if (supplier instanceof TickThrottledSupplier) {
            TickThrottledSupplier throttledSupplier = (TickThrottledSupplier)supplier;
            tickThrottledSupplier = new TickThrottledSupplier(tick, throttledSupplier.delegate);
        } else {
            tickThrottledSupplier = new TickThrottledSupplier<T>(tick, supplier);
        }
        return tickThrottledSupplier;
    }

    @NotNull
    public static FloatSupplier throttleTickFloat(@NotNull FloatSupplier supplier) {
        return FunctionUtil.throttleTickFloat(MathUtil.MINECRAFT_TICK_MILLS, supplier);
    }

    @NotNull
    public static FloatSupplier throttleTickFloat(long tick, @NotNull FloatSupplier supplier) {
        TickThrottledFloatSupplier tickThrottledFloatSupplier;
        if (supplier instanceof TickThrottledFloatSupplier) {
            TickThrottledFloatSupplier throttledSupplier = (TickThrottledFloatSupplier)supplier;
            tickThrottledFloatSupplier = new TickThrottledFloatSupplier(tick, throttledSupplier.delegate);
        } else {
            tickThrottledFloatSupplier = new TickThrottledFloatSupplier(tick, supplier);
        }
        return tickThrottledFloatSupplier;
    }

    @NotNull
    public static BooleanSupplier throttleTickBoolean(@NotNull BooleanSupplier supplier) {
        TickThrottledBooleanSupplier throttledSupplier;
        return supplier instanceof TickThrottledBooleanSupplier ? (throttledSupplier = (TickThrottledBooleanSupplier)supplier) : new TickThrottledBooleanSupplier(supplier);
    }

    @NotNull
    public static <T> Predicate<T> throttleTick(@NotNull Predicate<T> predicate) {
        TickThrottledPredicate<T> tickThrottledPredicate;
        if (predicate instanceof TickThrottledPredicate) {
            TickThrottledPredicate throttledSupplier = (TickThrottledPredicate)predicate;
            tickThrottledPredicate = throttledSupplier;
        } else {
            tickThrottledPredicate = new TickThrottledPredicate<T>(predicate);
        }
        return tickThrottledPredicate;
    }

    @NotNull
    public static <T, R> Function<T, R> throttleTick(@NotNull Function<T, R> function) {
        return FunctionUtil.throttleTick((long)MathUtil.MINECRAFT_TICK_MILLS, function);
    }

    @NotNull
    public static <T, R> Function<T, R> throttleTick(long tick, @NotNull Function<T, R> function) {
        TickThrottledFunction<T, R> tickThrottledFunction;
        if (function instanceof TickThrottledFunction) {
            TickThrottledFunction throttledFunction = (TickThrottledFunction)function;
            tickThrottledFunction = new TickThrottledFunction(tick, throttledFunction.delegate);
        } else {
            tickThrottledFunction = new TickThrottledFunction<T, R>(tick, function);
        }
        return tickThrottledFunction;
    }

    private static class PlayOnceRunnable
    implements Runnable {
        @NotNull
        private final Runnable delegate;
        private final AtomicBoolean played = new AtomicBoolean();

        @Override
        public void run() {
            if (this.played.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }

        @Generated
        public PlayOnceRunnable(@NotNull Runnable delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledSupplier<T>
    implements Supplier<T> {
        private final long tick;
        private final Supplier<T> delegate;
        private final AtomicLong time;
        private volatile T cache;

        public TickThrottledSupplier(long tick, @NotNull Supplier<T> delegate) {
            this.tick = tick;
            this.delegate = delegate;
            this.time = new AtomicLong(-tick - 1L);
        }

        @Override
        public T get() {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= this.tick && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.get();
            }
            return this.cache;
        }
    }

    private static class TickThrottledFloatSupplier
    implements FloatSupplier {
        private final long tick;
        private final FloatSupplier delegate;
        private final AtomicLong time;
        private volatile float cache;

        public TickThrottledFloatSupplier(long tick, @NotNull FloatSupplier delegate) {
            this.tick = tick;
            this.delegate = delegate;
            this.time = new AtomicLong(-tick - 1L);
        }

        @Override
        public float getAsFloat() {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= this.tick && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.getAsFloat();
            }
            return this.cache;
        }

        @Generated
        public TickThrottledFloatSupplier(long tick, FloatSupplier delegate, AtomicLong time) {
            this.tick = tick;
            this.delegate = delegate;
            this.time = time;
        }
    }

    private static class TickThrottledBooleanSupplier
    implements BooleanSupplier {
        @NotNull
        private final BooleanSupplier delegate;
        private final AtomicLong time = new AtomicLong(-51L);
        private volatile boolean cache;

        @Override
        public boolean getAsBoolean() {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.getAsBoolean();
            }
            return this.cache;
        }

        @Generated
        public TickThrottledBooleanSupplier(@NotNull BooleanSupplier delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledPredicate<T>
    implements Predicate<T> {
        @NotNull
        private final Predicate<T> delegate;
        private final AtomicLong time = new AtomicLong(-51L);
        private volatile boolean cache;

        @Override
        public boolean test(T t) {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.test(t);
            }
            return this.cache;
        }

        @Generated
        public TickThrottledPredicate(@NotNull Predicate<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledFunction<T, R>
    implements Function<T, R> {
        private final long tick;
        @NotNull
        private final Function<T, R> delegate;
        private final AtomicLong time;
        private volatile R cache;

        public TickThrottledFunction(long tick, @NotNull Function<T, R> delegate) {
            this.tick = tick;
            this.delegate = delegate;
            this.time = new AtomicLong(-tick - 1L);
        }

        @Override
        public R apply(T t) {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= this.tick && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.apply(t);
            }
            return this.cache;
        }

        @Generated
        public TickThrottledFunction(long tick, @NotNull Function<T, R> delegate, AtomicLong time) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.tick = tick;
            this.delegate = delegate;
            this.time = time;
        }
    }
}

