/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import java.util.Collection;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.ModelInteractionHand;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.EventsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0010\u001a\u00020\u000b*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl;", "Lkr/toxicity/model/api/manager/EntityManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "standardListener", "kr/toxicity/model/manager/EntityManagerImpl$standardListener$1", "Lkr/toxicity/model/manager/EntityManagerImpl$standardListener$1;", "platformListener", "Lorg/bukkit/event/Listener;", "start", "", "reload", "info", "Lkr/toxicity/model/api/manager/ReloadInfo;", "end", "forEachTracker", "Lorg/bukkit/entity/Entity;", "block", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/tracker/EntityTracker;", "triggerDismount", "", "Lorg/bukkit/entity/Player;", "e", "triggerMount", "hitBox", "Lkr/toxicity/model/api/nms/HitBox;", "PaperListener", "SpigotListener", "core"})
@SourceDebugExtension(value={"SMAP\nEntityManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityManagerImpl.kt\nkr/toxicity/model/manager/EntityManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1869#2,2:194\n1869#2,2:196\n1869#2,2:198\n*S KotlinDebug\n*F\n+ 1 EntityManagerImpl.kt\nkr/toxicity/model/manager/EntityManagerImpl\n*L\n163#1:194,2\n169#1:196,2\n176#1:198,2\n*E\n"})
public final class EntityManagerImpl
implements EntityManager,
GlobalManagerImpl {
    @NotNull
    public static final EntityManagerImpl INSTANCE = new EntityManagerImpl();
    @NotNull
    private static final standardListener.1 standardListener = new Listener(){

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void potion(EntityPotionEffectEvent $this$potion) {
            Intrinsics.checkNotNullParameter($this$potion, "<this>");
            Entity entity = $this$potion.getEntity();
            Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
            EntityManagerImpl.access$forEachTracker(EntityManagerImpl.INSTANCE, entity, standardListener.1::potion$lambda$0);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void dismount(EntityDismountEvent $this$dismount) {
            Intrinsics.checkNotNullParameter($this$dismount, "<this>");
            Entity entity = $this$dismount.getDismounted();
            Intrinsics.checkNotNullExpressionValue(entity, "getDismounted(...)");
            Entity e = entity;
            $this$dismount.setCancelled(e instanceof HitBox && (((HitBox)e).mountController().canFly() || !((HitBox)e).mountController().canDismountBySelf()) && !((HitBox)e).forceDismount());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void quit(PlayerQuitEvent $this$quit) {
            block1: {
                Intrinsics.checkNotNullParameter($this$quit, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$quit.getPlayer().getUniqueId());
                if (entityTrackerRegistry != null) {
                    entityTrackerRegistry.close();
                }
                Entity entity = $this$quit.getPlayer().getVehicle();
                HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                if (hitBox == null) break block1;
                hitBox.dismount((Entity)$this$quit.getPlayer());
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void load(ChunkLoadEvent $this$load) {
            Intrinsics.checkNotNullParameter($this$load, "<this>");
            Entity[] entityArray = $this$load.getChunk().getEntities();
            Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
            Object[] $this$forEach$iv = entityArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry(entity.getUniqueId());
                if (entityTrackerRegistry == null) continue;
                entityTrackerRegistry.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void unload(ChunkUnloadEvent $this$unload) {
            Intrinsics.checkNotNullParameter($this$unload, "<this>");
            Entity[] entityArray = $this$unload.getChunk().getEntities();
            Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
            Object[] $this$forEach$iv = entityArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry(entity.getUniqueId());
                if (entityTrackerRegistry == null) continue;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void death(EntityDeathEvent $this$death) {
            Intrinsics.checkNotNullParameter($this$death, "<this>");
            LivingEntity livingEntity = $this$death.getEntity();
            Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
            EntityManagerImpl.access$forEachTracker(EntityManagerImpl.INSTANCE, (Entity)livingEntity, standardListener.1::death$lambda$4);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void interact(PlayerInteractAtEntityEvent $this$interact) {
            block4: {
                ModelInteractionHand modelInteractionHand;
                Intrinsics.checkNotNullParameter($this$interact, "<this>");
                Entity entity = $this$interact.getRightClicked();
                HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                if (hitBox == null) break block4;
                Player player = $this$interact.getPlayer();
                switch (standardListener.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                    case 1: {
                        modelInteractionHand = ModelInteractionHand.RIGHT;
                        break;
                    }
                    case 2: {
                        modelInteractionHand = ModelInteractionHand.LEFT;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                hitBox.triggerInteractAt(player, modelInteractionHand, $this$interact.getClickedPosition());
            }
        }

        /*
         * Unable to fully structure code
         */
        @EventHandler(priority=EventPriority.MONITOR)
        public final void interact(PlayerInteractEntityEvent $this$interact) {
            block7: {
                Intrinsics.checkNotNullParameter($this$interact, "<this>");
                v0 = isRight = $this$interact.getHand() == EquipmentSlot.HAND;
                if (!isRight) ** GOTO lbl-1000
                v1 = $this$interact.getPlayer();
                Intrinsics.checkNotNullExpressionValue(v1, "getPlayer(...)");
                v2 = $this$interact.getRightClicked();
                Intrinsics.checkNotNullExpressionValue(v2, "getRightClicked(...)");
                if (EntityManagerImpl.access$triggerDismount(EntityManagerImpl.INSTANCE, v1, v2)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                dismount = v3;
                var4_4 = $this$interact.getRightClicked();
                v4 = var4_4 instanceof HitBox != false ? (HitBox)var4_4 : null;
                if (v4 == null) break block7;
                it = v4;
                $i$a$-let-EntityManagerImpl$standardListener$1$interact$1 = false;
                v5 = $this$interact.getPlayer();
                switch (standardListener.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                    case 1: {
                        v6 = ModelInteractionHand.RIGHT;
                        break;
                    }
                    case 2: {
                        v6 = ModelInteractionHand.LEFT;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                it.triggerInteract(v5, v6);
                if (isRight && !dismount) {
                    v7 = $this$interact.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(v7, "getPlayer(...)");
                    EntityManagerImpl.access$triggerMount(EntityManagerImpl.INSTANCE, v7, it);
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void damage(EntityDamageEvent $this$damage) {
            Intrinsics.checkNotNullParameter($this$damage, "<this>");
            if ($this$damage instanceof EntityDamageByEntityEvent) {
                Entity $this$damage_u24lambda_u246 = ((EntityDamageByEntityEvent)$this$damage).getEntity();
                boolean bl = false;
                UUID uUID = $this$damage_u24lambda_u246 instanceof HitBox ? ((HitBox)$this$damage_u24lambda_u246).source().getUniqueId() : $this$damage_u24lambda_u246.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "run(...)");
                UUID victim = uUID;
                Entity v = ((EntityDamageByEntityEvent)$this$damage).getDamager().getVehicle();
                if (v instanceof HitBox && !((HitBox)v).mountController().canBeDamagedByRider() && Intrinsics.areEqual(((HitBox)v).source().getUniqueId(), victim)) {
                    ((EntityDamageByEntityEvent)$this$damage).setCancelled(true);
                    return;
                }
            }
            Entity entity = $this$damage.getEntity();
            Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
            EntityManagerImpl.access$forEachTracker(EntityManagerImpl.INSTANCE, entity, standardListener.1::damage$lambda$7);
        }

        private static final Unit potion$lambda$0(EntityTracker it) {
            Intrinsics.checkNotNullParameter(it, "it");
            it.updateBaseEntity();
            return Unit.INSTANCE;
        }

        private static final void death$lambda$4$lambda$3(EntityTracker $it) {
            $it.close();
        }

        private static final Unit death$lambda$4(EntityTracker it) {
            Intrinsics.checkNotNullParameter(it, "it");
            if (!it.animate("death", AnimationModifier.DEFAULT_WITH_PLAY_ONCE, () -> standardListener.1.death$lambda$4$lambda$3(it))) {
                it.close();
            } else {
                it.forRemoval(true);
            }
            return Unit.INSTANCE;
        }

        private static final Unit damage$lambda$7(EntityTracker it) {
            Intrinsics.checkNotNullParameter(it, "it");
            it.animate("damage", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
            it.damageTint();
            return Unit.INSTANCE;
        }
    };
    @NotNull
    private static final Listener platformListener = BetterModel.IS_PAPER ? (Listener)new PaperListener() : (Listener)new SpigotListener();

    private EntityManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(standardListener);
        EventsKt.registerListener(platformListener);
    }

    @Override
    public void reload(@NotNull ReloadInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
        Collection<EntityTrackerRegistry> collection = EntityTrackerRegistry.REGISTRIES;
        Intrinsics.checkNotNullExpressionValue(collection, "REGISTRIES");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityTrackerRegistry it = (EntityTrackerRegistry)element$iv;
            boolean bl = false;
            it.reload();
        }
    }

    @Override
    public void end() {
        Collection<EntityTrackerRegistry> collection = EntityTrackerRegistry.REGISTRIES;
        Intrinsics.checkNotNullExpressionValue(collection, "REGISTRIES");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityTrackerRegistry it = (EntityTrackerRegistry)element$iv;
            boolean bl = false;
            it.save();
        }
    }

    private final void forEachTracker(Entity $this$forEachTracker, Function1<? super EntityTracker, Unit> block) {
        block1: {
            Object object = EntityTrackerRegistry.registry($this$forEachTracker.getUniqueId());
            if (object == null || (object = ((EntityTrackerRegistry)object).trackers()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                block.invoke((EntityTracker)element$iv);
            }
        }
    }

    private final boolean triggerDismount(Player $this$triggerDismount, Entity e) {
        Entity previous = $this$triggerDismount.getVehicle();
        if (!(previous instanceof HitBox)) {
            return false;
        }
        UUID uUID = e instanceof HitBox ? ((HitBox)e).source().getUniqueId() : e.getUniqueId();
        Intrinsics.checkNotNull(uUID);
        UUID uuid = uUID;
        if (Intrinsics.areEqual(((HitBox)previous).source().getUniqueId(), uuid) && ((HitBox)previous).mountController().canDismountBySelf()) {
            ((HitBox)previous).dismount((Entity)$this$triggerDismount);
            return true;
        }
        return false;
    }

    private final void triggerMount(Player $this$triggerMount, HitBox hitBox) {
        if (hitBox.mountController().canMount()) {
            hitBox.mount((Entity)$this$triggerMount);
        }
    }

    public static final /* synthetic */ boolean access$triggerDismount(EntityManagerImpl $this, Player $receiver, Entity e) {
        return $this.triggerDismount($receiver, e);
    }

    public static final /* synthetic */ void access$triggerMount(EntityManagerImpl $this, Player $receiver, HitBox hitBox) {
        $this.triggerMount($receiver, hitBox);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl$PaperListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "remove", "", "Lcom/destroystokyo/paper/event/entity/EntityRemoveFromWorldEvent;", "add", "Lcom/destroystokyo/paper/event/entity/EntityAddToWorldEvent;", "jump", "Lcom/destroystokyo/paper/event/entity/EntityJumpEvent;", "core"})
    private static final class PaperListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public final void remove(@NotNull EntityRemoveFromWorldEvent $this$remove) {
            block0: {
                Intrinsics.checkNotNullParameter($this$remove, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$remove.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void add(@NotNull EntityAddToWorldEvent $this$add) {
            block0: {
                Intrinsics.checkNotNullParameter($this$add, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$add.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void jump(@NotNull EntityJumpEvent $this$jump) {
            Intrinsics.checkNotNullParameter($this$jump, "<this>");
            LivingEntity livingEntity = $this$jump.getEntity();
            Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
            INSTANCE.forEachTracker((Entity)livingEntity, PaperListener::jump$lambda$0);
        }

        private static final Unit jump$lambda$0(EntityTracker it) {
            Intrinsics.checkNotNullParameter(it, "it");
            it.animate("jump");
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl$SpigotListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "remove", "", "Lorg/bukkit/event/entity/EntityRemoveEvent;", "add", "Lorg/bukkit/event/entity/EntityPortalEvent;", "Lorg/bukkit/event/player/PlayerPortalEvent;", "core"})
    private static final class SpigotListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public final void remove(@NotNull EntityRemoveEvent $this$remove) {
            block0: {
                Intrinsics.checkNotNullParameter($this$remove, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$remove.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void add(@NotNull EntityPortalEvent $this$add) {
            block0: {
                Intrinsics.checkNotNullParameter($this$add, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$add.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                EntityTrackerRegistry it = entityTrackerRegistry;
                boolean bl = false;
                it.despawn();
                it.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void add(@NotNull PlayerPortalEvent $this$add) {
            block0: {
                Intrinsics.checkNotNullParameter($this$add, "<this>");
                EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry($this$add.getPlayer().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                EntityTrackerRegistry it = entityTrackerRegistry;
                boolean bl = false;
                it.despawn();
                it.refresh();
            }
        }
    }
}

