/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.BiPredicate;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;

public sealed interface TrackerUpdateAction
extends BiPredicate<RenderedBone, BonePredicate> {
    @Override
    public boolean test(@NotNull RenderedBone var1, @NotNull BonePredicate var2);

    @NotNull
    public static Brightness brightness(int block, int sky) {
        return new Brightness(block, sky);
    }

    @NotNull
    public static Glow glow(boolean glow, int glowColor) {
        return new Glow(glow, glowColor);
    }

    @NotNull
    public static Tint tint(int rgb) {
        return new Tint(rgb);
    }

    @NotNull
    public static Enchant enchant(boolean enchant) {
        return enchant ? Enchant.TRUE : Enchant.FALSE;
    }

    @NotNull
    public static TogglePart togglePart(boolean toggle) {
        return toggle ? TogglePart.TRUE : TogglePart.FALSE;
    }

    @NotNull
    public static ItemStack itemStack(@NotNull TransformedItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        return new ItemStack(itemStack);
    }

    @NotNull
    public static Billboard billboard(@NotNull Display.Billboard billboard) {
        Objects.requireNonNull(billboard);
        return new Billboard(billboard);
    }

    public record Brightness(int block, int sky) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.brightness(p, this.block, this.sky);
        }
    }

    public record Glow(boolean glow, int glowColor) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.glow(p, this.glow, this.glowColor);
        }
    }

    public record Tint(int rgb) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.tint(p, this.rgb);
        }
    }

    public static enum Enchant implements TrackerUpdateAction
    {
        TRUE,
        FALSE;


        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.enchant(p, this == TRUE);
        }
    }

    public static enum TogglePart implements TrackerUpdateAction
    {
        TRUE,
        FALSE;


        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.togglePart(p, this == TRUE);
        }
    }

    public record ItemStack(@NotNull TransformedItemStack itemStack) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.itemStack(p, this.itemStack);
        }
    }

    public record Billboard(@NotNull Display.Billboard billboard) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone b2, @NotNull BonePredicate p) {
            return b2.billboard(p, this.billboard);
        }
    }
}

