/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.lazy;

import java.util.Objects;
import java.util.function.Supplier;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class LazyFloatProvider {
    private final FloatSupplier requiredTime;
    private long time = System.currentTimeMillis();
    private float storedValue;
    private boolean first = true;

    public LazyFloatProvider(long requiredTime) {
        this((float)requiredTime);
    }

    public LazyFloatProvider(float requiredTime) {
        this(() -> requiredTime);
    }

    public LazyFloatProvider(@NotNull FloatSupplier requiredTime) {
        this.requiredTime = requiredTime;
    }

    public float updateAndGet(float updateValue) {
        float req = this.requiredTime.getAsFloat();
        if (req <= 0.0f || this.first) {
            this.first = false;
            this.storedValue = updateValue;
            return this.storedValue;
        }
        long current = System.currentTimeMillis();
        float alpha = Math.clamp((float)(current - this.time) / req, 0.0f, 1.0f);
        this.time = current;
        this.storedValue = InterpolationUtil.lerp(this.storedValue, updateValue, alpha);
        return this.storedValue;
    }

    @NotNull
    public static Supplier<Vector3f> ofVector(long tick, @NotNull FloatSupplier requiredTime, @NotNull Supplier<Vector3f> delegate) {
        Objects.requireNonNull(requiredTime);
        Objects.requireNonNull(delegate);
        LazyFloatProvider xLazy = new LazyFloatProvider(requiredTime);
        LazyFloatProvider yLazy = new LazyFloatProvider(requiredTime);
        LazyFloatProvider zLazy = new LazyFloatProvider(requiredTime);
        return FunctionUtil.throttleTick(tick, () -> {
            Vector3f get = (Vector3f)delegate.get();
            get.x = xLazy.updateAndGet(get.x);
            get.y = yLazy.updateAndGet(get.y);
            get.z = zLazy.updateAndGet(get.z);
            return get;
        });
    }
}

