/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.function.BiFunction;
import java.util.function.Function;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.util.TransformedItemStack;
import org.bukkit.Material;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface BoneItemMapper
extends BiFunction<RenderSource, TransformedItemStack, TransformedItemStack> {
    public static final BoneItemMapper EMPTY = new BoneItemMapper(){

        @Override
        @NotNull
        public ItemDisplay.ItemDisplayTransform transform() {
            return ItemDisplay.ItemDisplayTransform.FIXED;
        }

        @Override
        @NotNull
        public TransformedItemStack apply(@NotNull RenderSource source, @NotNull TransformedItemStack transformedItemStack) {
            return transformedItemStack;
        }
    };

    @NotNull
    public static BoneItemMapper player(final @NotNull ItemDisplay.ItemDisplayTransform transform, final @NotNull Function<Player, TransformedItemStack> mapper) {
        return new BoneItemMapper(){
            private static final TransformedItemStack AIR = TransformedItemStack.of(new ItemStack(Material.AIR));

            @Override
            @NotNull
            public ItemDisplay.ItemDisplayTransform transform() {
                return transform;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public TransformedItemStack apply(RenderSource renderSource, TransformedItemStack transformedItemStack) {
                Player player2;
                if (!(renderSource instanceof RenderSource.BasePlayer)) return transformedItemStack;
                RenderSource.BasePlayer basePlayer = (RenderSource.BasePlayer)renderSource;
                try {
                    Player player;
                    player2 = player = basePlayer.entity();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                TransformedItemStack get = (TransformedItemStack)mapper.apply(player2);
                return get == null ? AIR : get;
            }
        };
    }

    @NotNull
    public ItemDisplay.ItemDisplayTransform transform();
}

