/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.UUID;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateDummyTrackerEvent;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class DummyTracker
extends Tracker {
    private Location location;
    private UUID uuid = UUID.randomUUID();

    public DummyTracker(@NotNull Location location, @NotNull RenderPipeline instance, @NotNull TrackerModifier modifier) {
        super(instance, modifier);
        this.location = location;
        instance.animate("spawn");
        instance.scale(() -> modifier.scale().scale(this));
        this.rotation(() -> new ModelRotation(0.0f, this.location.getYaw()));
        instance.defaultPosition(FunctionUtil.asSupplier(new Vector3f()));
        this.tint(0xFFFFFF);
        this.update();
        EventUtil.call(new CreateDummyTrackerEvent(this));
    }

    public void location(@NotNull Location location) {
        if (this.location.equals((Object)location)) {
            return;
        }
        this.location = Objects.requireNonNull(location, "location");
        PacketBundler bundler = this.pipeline.createBundler();
        this.pipeline.teleport(location, bundler);
        if (!bundler.isEmpty()) {
            this.pipeline.allPlayer().map(PlayerChannelHandler::player).forEach(bundler::send);
        }
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    public void spawn(@NotNull Player player) {
        PacketBundler bundler = this.pipeline.createBundler();
        this.spawn(player, bundler);
        bundler.send(player);
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

