/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateEntityTrackerEvent;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.EntityScript;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTracker
extends Tracker {
    private final EntityTrackerRegistry registry;
    private final AtomicBoolean shouldApplyDamageTint = new AtomicBoolean();
    private final AtomicInteger damageTintValue = new AtomicInteger(0xFF8080);
    private final AtomicLong damageTint = new AtomicLong(-1L);

    @Deprecated(forRemoval=true)
    @Nullable
    public static EntityTracker tracker(@NotNull Entity entity) {
        return EntityTracker.tracker(entity.getUniqueId());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static EntityTracker tracker(@NotNull UUID uuid) {
        return Optional.ofNullable(EntityTrackerRegistry.registry(uuid)).map(EntityTrackerRegistry::first).orElse(null);
    }

    @NotNull
    public UUID world() {
        return this.registry.entity().getWorld().getUID();
    }

    @ApiStatus.Internal
    public EntityTracker(@NotNull EntityTrackerRegistry registry, @NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier) {
        super(pipeline, modifier);
        this.registry = registry;
        Entity entity = registry.entity();
        EntityAdapter adapter = registry.adapter();
        FloatSupplier scale = FunctionUtil.throttleTickFloat(() -> modifier.scale().scale(this));
        if (modifier.shadow()) {
            ModelDisplay shadow = BetterModel.plugin().nms().create(entity.getLocation());
            float baseScale = (float)pipeline.bones().stream().filter(b -> b.getGroup().getParent().visibility()).map(b -> b.getGroup().getHitBox()).filter(Objects::nonNull).mapToDouble(b -> Math.max(b.box().x(), b.box().z())).max().orElse(0.0);
            this.tick((t, b) -> {
                shadow.shadowRadius(scale.getAsFloat() * baseScale);
                shadow.sync(adapter);
                shadow.sendEntityData((PacketBundler)b);
                shadow.syncPosition(adapter, (PacketBundler)b);
            });
            pipeline.spawnPacketHandler(shadow::spawn);
            pipeline.despawnPacketHandler(shadow::remove);
            pipeline.hidePacketHandler(b -> shadow.sendEntityData(false, (PacketBundler)b));
            pipeline.showPacketHandler(shadow::sendEntityData);
        }
        pipeline.defaultPosition(FunctionUtil.throttleTick(() -> adapter.passengerPosition().mul(-1.0f)));
        pipeline.scale(scale);
        Function<Quaternionf, Quaternionf> headRotator = r -> r.mul((Quaternionfc)MathUtil.toQuaternion(new Vector3f(Math.clamp(adapter.pitch(), -90.0f, 90.0f), Math.clamp(-adapter.yaw() + adapter.bodyYaw(), -90.0f, 90.0f), 0.0f)));
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.NOT_SET, r -> r.getName().tagged(BoneTags.HEAD)), headRotator);
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.TRUE, r -> r.getName().tagged(BoneTags.HEAD_WITH_CHILDREN)), headRotator);
        FloatSupplier damageTickProvider = FunctionUtil.throttleTickFloat(adapter::damageTick);
        BooleanSupplier walkSupplier = FunctionUtil.throttleTickBoolean(() -> adapter.onWalk() || (double)damageTickProvider.getAsFloat() > 0.25 || pipeline.bones().stream().anyMatch(e -> {
            HitBox hitBox = e.getHitBox();
            return hitBox != null && hitBox.onWalk();
        }));
        FloatSupplier walkSpeedSupplier = FunctionUtil.throttleTickFloat(modifier.damageAnimation() ? () -> adapter.walkSpeed() + 4.0f * (float)Math.sqrt(damageTickProvider.getAsFloat()) : () -> 1.0f);
        pipeline.animate("walk", new AnimationModifier(walkSupplier, 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        pipeline.animate("idle_fly", new AnimationModifier(adapter::fly, 6, 0, AnimationIterator.Type.LOOP, 1.0f));
        pipeline.animate("walk_fly", new AnimationModifier(() -> adapter.fly() && walkSupplier.getAsBoolean(), 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        pipeline.animate("spawn", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
        BetterModel.plugin().scheduler().task(entity, () -> {
            if (this.isClosed()) {
                return;
            }
            this.createHitBox();
        });
        this.tick((t, b) -> this.updateBaseEntity0());
        this.tick((t, b) -> {
            BlueprintScript.ScriptReader reader = t.pipeline.getScriptProcessor().getCurrentReader();
            if (reader == null) {
                return;
            }
            EntityScript script = reader.script();
            if (script == null) {
                return;
            }
            BetterModel.plugin().scheduler().task(entity, () -> script.accept(entity));
        });
        this.tick(2L, (t, b) -> {
            if (adapter.dead() && !this.forRemoval()) {
                this.close();
            }
        });
        this.tick((t, b) -> {
            if (this.shouldApplyDamageTint.compareAndSet(true, false)) {
                this.tint(this.damageTintValue.get());
            } else if (this.damageTint.getAndDecrement() == 0L) {
                this.tint(-1);
            }
        });
        this.rotation(() -> adapter.dead() ? pipeline.getRotation() : new ModelRotation(0.0f, entity instanceof LivingEntity ? adapter.bodyYaw() : entity.getYaw()));
        this.tint(0xFFFFFF);
        this.update();
        EventUtil.call(new CreateEntityTrackerEvent(this));
    }

    private void createHitBox() {
        this.createHitBox(e -> e.getName().name().equals("hitbox") || e.getName().tagged(BoneTags.HITBOX) || e.getGroup().getMountController().canMount());
    }

    private void createHitBox(@NotNull Predicate<RenderedBone> predicate) {
        this.createHitBox(predicate, HitBoxListener.EMPTY);
    }

    public void updateBaseEntity() {
        BetterModel.plugin().scheduler().taskLater(1L, this.registry.entity(), () -> {
            this.updateBaseEntity0();
            this.forceUpdate(true);
        });
    }

    private void updateBaseEntity0() {
        this.displays().forEach(d -> d.sync(this.registry.adapter()));
    }

    @NotNull
    public EntityTrackerRegistry registry() {
        return this.registry;
    }

    public void createHitBox(@NotNull Predicate<RenderedBone> predicate, @NotNull HitBoxListener listener) {
        this.pipeline.createHitBox(this.registry.adapter(), predicate, listener);
    }

    public int damageTintValue() {
        return this.damageTintValue.get();
    }

    public void damageTintValue(int tint) {
        this.damageTintValue.set(tint);
    }

    public void damageTint() {
        if (!this.modifier().damageTint()) {
            return;
        }
        long get = this.damageTint.get();
        if (get <= 0L && this.damageTint.compareAndSet(get, 10L)) {
            this.shouldApplyDamageTint.set(true);
        }
    }

    @Override
    public void close() {
        super.close();
        Entity entity = this.registry.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.updateInventory();
        }
    }

    @Override
    public void despawn() {
        if (this.registry.adapter().dead()) {
            this.close();
            return;
        }
        super.despawn();
    }

    @Override
    @NotNull
    public Location location() {
        return this.registry.entity().getLocation();
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.registry.entity().getUniqueId();
    }

    @NotNull
    public Entity sourceEntity() {
        return this.registry.entity();
    }

    public void moveDuration(int duration) {
        this.pipeline.moveDuration(duration);
        this.forceUpdate(true);
    }

    public void cancelDamageTint() {
        this.damageTint.set(-1L);
    }

    @ApiStatus.Internal
    public void refresh() {
        BetterModel.plugin().scheduler().task(this.registry.entity(), () -> this.pipeline.createHitBox(this.registry.adapter(), r -> r.getHitBox() != null, null));
    }

    @Override
    public boolean hide(@NotNull Player player) {
        boolean success = super.hide(player);
        if (success) {
            BetterModel.plugin().scheduler().task((Entity)player, () -> player.hideEntity((Plugin)BetterModel.plugin(), this.registry.entity()));
        }
        return success;
    }

    @Override
    public boolean show(@NotNull Player player) {
        boolean success = super.show(player);
        if (success) {
            BetterModel.plugin().scheduler().task((Entity)player, () -> player.showEntity((Plugin)BetterModel.plugin(), this.registry.entity()));
        }
        return success;
    }
}

