/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolation;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.VectorUtil;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import org.jetbrains.annotations.NotNull;

public enum CatmullRomInterpolation implements VectorInterpolation
{
    INSTANCE;


    @NotNull
    private static VectorPoint indexOf(@NotNull List<VectorPoint> list, int index, int relative) {
        int i = index + relative;
        if (i < 0) {
            i += list.size();
        } else if (i >= list.size()) {
            i = list.getFirst().time() <= 0.0f ? i % (list.size() - 1) + 1 : i % list.size();
        }
        return list.get(i);
    }

    @Override
    @NotNull
    public VectorPoint interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
        if (points.size() < 4) {
            return VectorInterpolation.defaultInterpolation().interpolate(points, p2Index, time);
        }
        VectorPoint p0 = CatmullRomInterpolation.indexOf(points, p2Index, -2);
        VectorPoint p1 = CatmullRomInterpolation.indexOf(points, p2Index, -1);
        VectorPoint p2 = points.get(p2Index);
        VectorPoint p3 = CatmullRomInterpolation.indexOf(points, p2Index, 1);
        return new VectorPoint(VectorUtil.catmull_rom(p0.vector(), p1.vector(), p2.vector(), p3.vector(), VectorUtil.alpha(p1.time(), p2.time(), time)), time, this);
    }
}

