/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.ConfigManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.manager.PlayerManagerImpl;
import kr.toxicity.model.manager.SkinManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00020\f*\u00020 H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkr/toxicity/model/manager/PlayerManagerImpl;", "Lkr/toxicity/model/api/manager/PlayerManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/model/api/nms/PlayerChannelHandler;", "renderMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "start", "", "register", "Lorg/bukkit/entity/Player;", "reload", "info", "Lkr/toxicity/model/api/manager/ReloadInfo;", "limbs", "", "limb", "name", "animate", "player", "model", "animation", "modifier", "Lkr/toxicity/model/api/animation/AnimationModifier;", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "uuid", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1617#2,9:112\n1869#2:121\n1870#2:123\n1626#2:124\n1617#2,9:125\n1869#2:134\n1870#2:136\n1626#2:137\n1#3:122\n1#3:135\n*S KotlinDebug\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n*L\n102#1:112,9\n102#1:121\n102#1:123\n102#1:124\n94#1:125,9\n94#1:134\n94#1:136\n94#1:137\n102#1:122\n94#1:135\n*E\n"})
public final class PlayerManagerImpl
implements PlayerManager,
GlobalManagerImpl {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, ModelRenderer> renderMap = new HashMap();

    private PlayerManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void join(PlayerJoinEvent $this$join) {
                Intrinsics.checkNotNullParameter($this$join, "<this>");
                if ($this$join.getPlayer().isOnline()) {
                    Object object;
                    PlayerJoinEvent playerJoinEvent = $this$join;
                    try {
                        PlayerJoinEvent $this$join_u24lambda_u240 = playerJoinEvent;
                        boolean bl = false;
                        Player player = $this$join_u24lambda_u240.getPlayer();
                        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                        object = Result.constructor-impl(PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    PluginsKt.handleFailure(object, () -> start.1.join$lambda$1($this$join));
                }
            }

            @EventHandler
            public final void change(PlayerChangedWorldEvent $this$change) {
                Intrinsics.checkNotNullParameter($this$change, "<this>");
                if ($this$change.getPlayer().isOnline()) {
                    Object object;
                    PlayerChangedWorldEvent playerChangedWorldEvent = $this$change;
                    try {
                        PlayerChangedWorldEvent $this$change_u24lambda_u242 = playerChangedWorldEvent;
                        boolean bl = false;
                        Player player = $this$change_u24lambda_u242.getPlayer();
                        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                        PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player).unregisterAll();
                        object = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    PluginsKt.handleFailure(object, () -> start.1.change$lambda$3($this$change));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                Intrinsics.checkNotNullParameter($this$quit, "<this>");
                PlayerChannelHandler playerChannelHandler = (PlayerChannelHandler)PlayerManagerImpl.access$getPlayerMap$p().remove($this$quit.getPlayer().getUniqueId());
                if (playerChannelHandler != null) {
                    AutoCloseable autoCloseable = playerChannelHandler;
                    Throwable throwable = null;
                    try {
                        PlayerChannelHandler it = (PlayerChannelHandler)autoCloseable;
                        boolean bl = false;
                        GameProfile gameProfile = it.profile();
                        Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
                        Boolean bl2 = SkinManagerImpl.INSTANCE.removeCache(gameProfile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
            }

            private static final String join$lambda$1(PlayerJoinEvent $this_join) {
                return "Unable to load " + $this_join.getPlayer().getName() + "'s data.";
            }

            private static final String change$lambda$3(PlayerChangedWorldEvent $this_change) {
                return "Unable to refresh " + $this_change.getPlayer().getName() + "'s data.";
            }
        });
    }

    private final PlayerChannelHandler register(Player $this$register) {
        PlayerChannelHandler playerChannelHandler;
        PlayerChannelHandler $this$register_u24lambda_u242 = playerChannelHandler = playerMap.computeIfAbsent($this$register.getUniqueId(), arg_0 -> PlayerManagerImpl.register$lambda$1(arg_0 -> PlayerManagerImpl.register$lambda$0($this$register, arg_0), arg_0));
        boolean bl = false;
        if (SkinManagerImpl.INSTANCE.supported()) {
            GameProfile gameProfile = $this$register_u24lambda_u242.profile();
            Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
            SkinManagerImpl.INSTANCE.getOrRequest(gameProfile);
        }
        PlayerChannelHandler playerChannelHandler2 = playerChannelHandler;
        Intrinsics.checkNotNullExpressionValue(playerChannelHandler2, "apply(...)");
        return playerChannelHandler2;
    }

    @Override
    public void reload(@NotNull ReloadInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
        renderMap.clear();
        if (ConfigManagerImpl.INSTANCE.module().playerAnimation()) {
            kr.toxicity.model.util.FilesKt.forEachAllFolder(kr.toxicity.model.util.FilesKt.getOrCreateDirectory(PluginsKt.getDATA_FOLDER(), "players", PlayerManagerImpl::reload$lambda$3), PlayerManagerImpl::reload$lambda$4);
        }
    }

    @Override
    @NotNull
    public List<ModelRenderer> limbs() {
        Collection<ModelRenderer> collection = renderMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @Nullable
    public ModelRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return renderMap.get(name);
    }

    @Override
    public void animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier) {
        block1: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(model, "model");
            Intrinsics.checkNotNullParameter(animation, "animation");
            Intrinsics.checkNotNullParameter(modifier, "modifier");
            ModelRenderer modelRenderer = renderMap.get(model);
            if (modelRenderer == null) break block1;
            ModelRenderer it = modelRenderer;
            boolean bl = false;
            EntityTracker entityTracker = it.getOrCreate((Entity)player);
            Intrinsics.checkNotNullExpressionValue(entityTracker, "getOrCreate(...)");
            EntityTracker create = entityTracker;
            if (!create.animate(animation, modifier, () -> PlayerManagerImpl.animate$lambda$6$lambda$5(create))) {
                create.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ModelRenderer toRenderer(ModelBlueprint $this$toRenderer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<BlueprintChildren> list = $this$toRenderer.group();
        Intrinsics.checkNotNullExpressionValue(list, "group(...)");
        Iterable iterable = list;
        ModelBlueprint modelBlueprint = $this$toRenderer;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<BoneName, RendererGroup> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlueprintChildren it = (BlueprintChildren)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof BlueprintChildren.BlueprintGroup ? TuplesKt.to(((BlueprintChildren.BlueprintGroup)it).boneName(), PlayerManagerImpl.toRenderer$parse((BlueprintChildren.BlueprintGroup)it, $this$toRenderer)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
        Map<BoneName, RendererGroup> map2 = MapsKt.toMap((List)destination$iv$iv);
        ModelBlueprint modelBlueprint2 = modelBlueprint;
        return new ModelRenderer(modelBlueprint2, map2, map);
    }

    @Override
    @Nullable
    public PlayerChannelHandler player(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return playerMap.get(uuid);
    }

    @Override
    @NotNull
    public PlayerChannelHandler player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.register(player);
    }

    @Override
    public void end() {
        GlobalManagerImpl.DefaultImpls.end(this);
    }

    private static final PlayerChannelHandler register$lambda$0(Player $this_register, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return PluginsKt.getPLUGIN().nms().inject($this_register);
    }

    private static final PlayerChannelHandler register$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerChannelHandler)$tmp0.invoke(p0);
    }

    private static final Unit reload$lambda$3(File folder) {
        Intrinsics.checkNotNullParameter(folder, "folder");
        kr.toxicity.model.util.FilesKt.addResourceAs(folder, "steve.bbmodel");
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$4(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(FilesKt.getExtension(it), "bbmodel")) {
            ModelBlueprint load = GsonsKt.toModel(it);
            ((Map)renderMap).put(load.name(), INSTANCE.toRenderer(load));
        }
        return Unit.INSTANCE;
    }

    private static final void animate$lambda$6$lambda$5(EntityTracker $create) {
        $create.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final RendererGroup toRenderer$parse(BlueprintChildren.BlueprintGroup $this$toRenderer_u24parse, ModelBlueprint $this_toRenderer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        BoneName boneName = $this$toRenderer_u24parse.boneName();
        float f = $this_toRenderer.scale();
        ItemStack itemStack = new ItemStack(Material.AIR);
        List<BlueprintChildren> list = $this$toRenderer_u24parse.children();
        Intrinsics.checkNotNullExpressionValue(list, "children(...)");
        Iterable iterable = list;
        BlueprintChildren.BlueprintGroup blueprintGroup = $this$toRenderer_u24parse;
        ItemStack itemStack2 = itemStack;
        float f2 = f;
        BoneName boneName2 = boneName;
        boolean $i$f$mapNotNull = false;
        void var4_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<BoneName, RendererGroup> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlueprintChildren it = (BlueprintChildren)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof BlueprintChildren.BlueprintGroup ? TuplesKt.to(((BlueprintChildren.BlueprintGroup)it).boneName(), PlayerManagerImpl.toRenderer$parse((BlueprintChildren.BlueprintGroup)it, $this_toRenderer)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        NamedBoundingBox namedBoundingBox = $this$toRenderer_u24parse.hitBox();
        Map<BoneName, RendererGroup> map = MapsKt.toMap(list2);
        BlueprintChildren.BlueprintGroup blueprintGroup2 = blueprintGroup;
        ItemStack itemStack3 = itemStack2;
        float f3 = f2;
        BoneName boneName3 = boneName2;
        return new RendererGroup(boneName3, f3, itemStack3, blueprintGroup2, map, namedBoundingBox);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerMap$p() {
        return playerMap;
    }

    public static final /* synthetic */ PlayerChannelHandler access$register(PlayerManagerImpl $this, Player $receiver) {
        return $this.register($receiver);
    }
}

