/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.data.Float3;
import kr.toxicity.model.api.data.raw.KeyframeChannel;
import kr.toxicity.model.api.data.raw.ModelDatapoint;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public record ModelKeyframe(@Nullable KeyframeChannel channel, @SerializedName(value="data_points") @NotNull List<ModelDatapoint> dataPoints, @SerializedName(value="bezier_left_time") @Nullable Float3 bezierLeftTime, @SerializedName(value="bezier_left_value") @Nullable Float3 bezierLeftValue, @SerializedName(value="bezier_right_time") @Nullable Float3 bezierRightTime, @SerializedName(value="bezier_right_value") @Nullable Float3 bezierRightValue, @Nullable VectorInterpolator interpolation, float time) implements Timed
{
    @Nullable
    private final KeyframeChannel channel;
    @Nullable
    private final VectorInterpolator interpolation;

    public boolean hasPoint() {
        return !this.dataPoints.isEmpty();
    }

    @NotNull
    public ModelDatapoint point() {
        return this.dataPoints.getFirst();
    }

    @NotNull
    public VectorPoint point(@NotNull ModelLoadContext context, @NotNull Function<Vector3f, Vector3f> function) {
        return new VectorPoint(this.point().toFunction(context).map(function).memoize(), this.time(), new VectorPoint.BezierConfig(Optional.ofNullable(this.bezierLeftTime).map(Float3::toVector).orElse(null), Optional.ofNullable(this.bezierLeftValue).map(Float3::toVector).map(function).orElse(null), Optional.ofNullable(this.bezierRightTime).map(Float3::toVector).orElse(null), Optional.ofNullable(this.bezierRightValue).map(Float3::toVector).map(function).orElse(null)), this.interpolation());
    }

    @NotNull
    public VectorInterpolator interpolation() {
        return this.interpolation != null ? this.interpolation : VectorInterpolator.LINEAR;
    }

    @NotNull
    public KeyframeChannel channel() {
        return this.channel != null ? this.channel : KeyframeChannel.NOT_FOUND;
    }
}

