/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import kr.toxicity.model.api.data.Float4;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModelUV(@NotNull Float4 uv, float rotation, @Nullable JsonElement texture) {
    public boolean hasTexture() {
        return this.texture != null && this.texture.isJsonPrimitive() && this.texture.getAsJsonPrimitive().isNumber();
    }

    public int textureIndex() {
        return Objects.requireNonNull(this.texture).getAsInt();
    }

    @NotNull
    public JsonObject toJson(@NotNull ModelBlueprint parent, int tint) {
        JsonObject object = new JsonObject();
        object.add("uv", (JsonElement)this.uv.div(parent.textures().get(this.textureIndex()).resolution(parent.resolution())).toJson());
        if (this.rotation != 0.0f) {
            object.addProperty("rotation", (Number)Float.valueOf(this.rotation));
        }
        object.addProperty("tintindex", (Number)tint);
        object.addProperty("texture", "#" + String.valueOf(this.texture));
        return object;
    }
}

