/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import kr.toxicity.model.api.data.Float3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class MathUtil {
    public static final int MINECRAFT_TICK_MILLS = 50;
    public static final float ROTATION_DEGREE = 22.5f;
    public static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    public static final float RADIANS_TO_DEGREES = 57.29578f;
    public static final float DEGREES_TO_PACKED_BYTE = 0.7111111f;
    public static final float MODEL_TO_BLOCK_MULTIPLIER = 16.0f;
    public static final float FRAME_EPSILON = 0.001f;
    public static final float FLOAT_COMPARISON_EPSILON = 1.0E-5f;
    public static final FloatComparator FRAME_COMPARATOR = (a, b) -> MathUtil.isSimilar(a, b, 0.001f) ? 0 : Float.compare(a, b);
    private static final Vector3f FORWARD_AXIS = new Vector3f(0.0f, -1.0f, 0.0f).normalize();
    private static final FloatSet VALID_ROTATION_DEGREES = FloatSet.of((float[])new float[]{0.0f, 22.5f, 45.0f, -22.5f, -45.0f});

    private MathUtil() {
        throw new RuntimeException();
    }

    public static boolean isSimilar(float a, float b) {
        return MathUtil.isSimilar(a, b, 1.0E-5f);
    }

    public static boolean isSimilar(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static boolean isSimilar(@NotNull Vector3f a, @NotNull Vector3f b) {
        return MathUtil.isSimilar(a, b, 1.0E-5f);
    }

    public static boolean isSimilar(@NotNull Vector3f a, @NotNull Vector3f b, float epsilon) {
        return MathUtil.isSimilar(a.x, b.x, epsilon) && MathUtil.isSimilar(a.y, b.y, epsilon) && MathUtil.isSimilar(a.z, b.z, epsilon);
    }

    public static boolean isSimilar(@NotNull Quaternionf a, @NotNull Quaternionf b) {
        return MathUtil.isSimilar(a, b, 1.0E-5f);
    }

    public static boolean isSimilar(@NotNull Quaternionf a, @NotNull Quaternionf b, float epsilon) {
        return MathUtil.isSimilar(a.x, b.x, epsilon) && MathUtil.isSimilar(a.y, b.y, epsilon) && MathUtil.isSimilar(a.z, b.z, epsilon) && MathUtil.isSimilar(a.w, b.w, epsilon);
    }

    public static int similarHashCode(float value) {
        return (int)(value / 1.0E-5f);
    }

    public static boolean checkValidDegree(@NotNull Float3 rotation2) {
        int i2 = 0;
        if (rotation2.x() != 0.0f) {
            ++i2;
        }
        if (rotation2.y() != 0.0f) {
            ++i2;
        }
        if (rotation2.z() != 0.0f) {
            ++i2;
        }
        return i2 < 2 && MathUtil.checkValidDegree(rotation2.x()) && MathUtil.checkValidDegree(rotation2.y()) && MathUtil.checkValidDegree(rotation2.z());
    }

    public static boolean checkValidDegree(float rotation2) {
        return VALID_ROTATION_DEGREES.contains(rotation2);
    }

    @NotNull
    public static Float3 identifier(@NotNull Float3 rotation2) {
        if (MathUtil.checkValidDegree(rotation2)) {
            return Float3.ZERO;
        }
        return rotation2;
    }

    @NotNull
    public static Quaternionf toQuaternion(@NotNull Vector3f vector) {
        return new Quaternionf().rotateZYX(vector.z * ((float)Math.PI / 180), vector.y * ((float)Math.PI / 180), vector.x * ((float)Math.PI / 180));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Vector3f vec) {
        return MathUtil.toXYZEuler(MathUtil.toQuaternion(vec));
    }

    @NotNull
    public static Matrix3f toMatrix(@NotNull Quaternionf quaternion) {
        return quaternion.get(new Matrix3f());
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Quaternionf quaternion) {
        return MathUtil.toXYZEuler(MathUtil.toMatrix(quaternion));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Matrix3f mat) {
        Vector3f ret = new Vector3f();
        if (Math.abs(mat.m20) < 1.0f) {
            ret.x = (float)Math.atan2(-mat.m21, mat.m22);
            ret.z = (float)Math.atan2(-mat.m10, mat.m00);
        } else {
            ret.x = (float)Math.atan2(mat.m12, mat.m11);
            ret.z = 0.0f;
        }
        ret.y = (float)Math.asin(Math.clamp(mat.m20, -1.0f, 1.0f));
        return ret.mul(57.29578f);
    }

    @NotNull
    public static Quaternionf fromToRotation(@NotNull Vector3f to, @NotNull Quaternionf dest) {
        return MathUtil.fromToRotation(FORWARD_AXIS, to, dest);
    }

    @NotNull
    public static Quaternionf fromToRotation(@NotNull Vector3f from, @NotNull Vector3f to, @NotNull Quaternionf dest) {
        Vector3f cache = new Vector3f();
        Vector3f axis = from.cross((Vector3fc)to, cache);
        float len = axis.length();
        float dot = from.dot((Vector3fc)to);
        if (len < 1.0E-6f) {
            if (dot > 0.999999f) {
                return dest.identity();
            }
            Vector3f ortho = Math.abs(from.x) < 0.9f ? from.cross(1.0f, 0.0f, 0.0f, cache) : from.cross(0.0f, 1.0f, 0.0f, cache);
            return dest.fromAxisAngleRad((Vector3fc)ortho.normalize(), (float)Math.PI);
        }
        return dest.fromAxisAngleRad((Vector3fc)axis.div(len), (float)Math.atan2(len, dot));
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a, @NotNull Vector3f b, @NotNull Vector3f c) {
        a.x = MathUtil.fma(a.x, b.x, c.x);
        a.y = MathUtil.fma(a.y, b.y, c.y);
        a.z = MathUtil.fma(a.z, b.z, c.z);
        return a;
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a, float b, @NotNull Vector3f c) {
        a.x = MathUtil.fma(a.x, b, c.x);
        a.y = MathUtil.fma(a.y, b, c.y);
        a.z = MathUtil.fma(a.z, b, c.z);
        return a;
    }

    public static float fma(float a, float b, float c) {
        return org.joml.Math.fma((float)a, (float)b, (float)c);
    }

    public static double fma(double a, double b, double c) {
        return org.joml.Math.fma((double)a, (double)b, (double)c);
    }

    public static boolean isNotZero(@NotNull Vector3f vector3f) {
        return !MathUtil.isZero(vector3f);
    }

    public static boolean isZero(@NotNull Vector3f vector3f) {
        return MathUtil.isSimilar(vector3f.x, 0.0f) && MathUtil.isSimilar(vector3f.y, 0.0f) && MathUtil.isSimilar(vector3f.z, 0.0f);
    }
}

