/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.Objects;
import java.util.function.Supplier;
import kr.toxicity.model.api.pack.PackOverlay;
import kr.toxicity.model.api.pack.PackPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PackResource
extends Supplier<byte[]> {
    @Nullable
    public PackOverlay overlay();

    @NotNull
    public PackPath path();

    public long estimatedSize();

    @NotNull
    public static PackResource of(@NotNull PackPath path, long size, @NotNull Supplier<byte[]> supplier) {
        return PackResource.of(null, path, size, supplier);
    }

    @NotNull
    public static PackResource of(@Nullable PackOverlay overlay, @NotNull PackPath path, long size, @NotNull Supplier<byte[]> supplier) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(supplier, "supplier");
        return new Packed(overlay, path, size, supplier);
    }

    public record Packed(@Nullable PackOverlay overlay, @NotNull PackPath path, long estimatedSize, @NotNull Supplier<byte[]> supplier) implements PackResource
    {
        @Override
        public byte[] get() {
            return this.supplier.get();
        }
    }
}

