/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PlayerTracker
extends EntityTracker {
    private final Player player;

    public PlayerTracker(@NotNull Player entity, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        super((Entity)entity, instance, modifier);
        this.player = entity;
        instance.spawnFilter(p -> {
            PlayerChannelHandler handler2 = BetterModel.inst().playerManager().player(p.getUniqueId());
            return handler2 != null && handler2.showPlayerLimb();
        });
        this.autoSpawn(false);
    }

    @Override
    public boolean isRunningSingleAnimation() {
        return false;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.player.updateInventory();
    }
}

