/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorData;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum ArmorResource {
    HELMET("armor/helmet.json"),
    CHEST("armor/chest.json"),
    WAIST("armor/waist.json"),
    HIP("armor/hip.json"),
    LEFT_ARM("armor/left_arm.json"),
    RIGHT_ARM("armor/right_arm.json"),
    LEFT_LEG("armor/left_leg.json"),
    RIGHT_LEG("armor/right_leg.json"),
    LEFT_FORELEG("armor/left_foreleg.json"),
    RIGHT_FORELEG("armor/right_foreleg.json");

    @NotNull
    private final String path;

    @NotNull
    public String path() {
        return this.path;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ArmorData read(@NotNull StreamLoader loader) {
        try (InputStream stream = loader.load(this.path);){
            ArmorData armorData;
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                armorData = (ArmorData)ArmorData.GSON.fromJson((Reader)reader, ArmorData.class);
            }
            return armorData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private ArmorResource(String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }

    @FunctionalInterface
    public static interface StreamLoader {
        public static final StreamLoader DEFAULT = path -> Objects.requireNonNull(ArmorResource.class.getResourceAsStream("/" + path));

        @NotNull
        public InputStream load(@NotNull String var1) throws IOException;
    }
}

