/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.script.BlueprintScript;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptProcessor {
    private final Map<String, PredicatedScript> scriptMap = new LinkedHashMap<String, PredicatedScript>();
    @Nullable
    private BlueprintScript.ScriptReader currentReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateSingle(@NotNull BlueprintScript script, @NotNull AnimationModifier modifier) {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            this.scriptMap.put(script.name(), new PredicatedScript(script.name(), modifier.predicate(), script.single(modifier.start(), modifier.speed())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateLoop(@NotNull BlueprintScript script, @NotNull AnimationModifier modifier) {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            this.scriptMap.put(script.name(), new PredicatedScript(script.name(), modifier.predicate(), script.loop(modifier.start(), modifier.speed())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSingle(@NotNull BlueprintScript script, @NotNull AnimationModifier modifier) {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            this.scriptMap.replace(script.name(), new PredicatedScript(script.name(), modifier.predicate(), script.single(modifier.start(), modifier.speed())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLoop(@NotNull BlueprintScript script, @NotNull AnimationModifier modifier) {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            this.scriptMap.replace(script.name(), new PredicatedScript(script.name(), modifier.predicate(), script.loop(modifier.start(), modifier.speed())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull String animation) {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            this.scriptMap.remove(animation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Map<String, PredicatedScript> map = this.scriptMap;
        synchronized (map) {
            boolean check = true;
            for (PredicatedScript predicatedScript : new ArrayList<PredicatedScript>(this.scriptMap.values()).reversed()) {
                if (predicatedScript.supplier.get().booleanValue() && check) {
                    check = false;
                    if (predicatedScript.reader.tick()) {
                        this.scriptMap.remove(predicatedScript.name);
                        continue;
                    }
                    this.currentReader = predicatedScript.reader;
                    continue;
                }
                predicatedScript.reader.clear();
            }
            if (check) {
                this.currentReader = null;
            }
        }
    }

    @Nullable
    @Generated
    public BlueprintScript.ScriptReader getCurrentReader() {
        return this.currentReader;
    }

    private record PredicatedScript(@NotNull String name, @NotNull Supplier<Boolean> supplier, @NotNull BlueprintScript.ScriptReader reader) {
    }
}

