/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import kr.toxicity.model.api.util.AnimationPoint;
import kr.toxicity.model.api.util.VectorInterpolation;
import kr.toxicity.model.api.util.VectorPoint;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VectorUtil {
    private VectorUtil() {
        throw new RuntimeException();
    }

    private static void point(@NotNull Collection<Float> target, List<VectorPoint> points) {
        for (VectorPoint point : points) {
            target.add(Float.valueOf(point.time()));
        }
    }

    @NotNull
    public static List<AnimationPoint> putAnimationPoint(@NotNull List<AnimationPoint> animations, @NotNull Collection<Float> points) {
        return VectorUtil.sum(animations.stream().map(AnimationPoint::position).distinct().toList(), animations.stream().map(AnimationPoint::rotation).distinct().toList(), animations.stream().map(AnimationPoint::scale).distinct().toList(), points);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale) {
        TreeSet<Float> set = new TreeSet<Float>();
        VectorUtil.point(set, position);
        VectorUtil.point(set, scale);
        VectorUtil.point(set, rotation);
        return VectorUtil.sum(position, rotation, scale, set);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale, Collection<Float> points) {
        ArrayList<AnimationPoint> list = new ArrayList<AnimationPoint>();
        List<VectorPoint> pp = VectorUtil.putPoint(position, points);
        List<VectorPoint> rp = VectorUtil.putPoint(rotation, points);
        List<VectorPoint> sp = VectorUtil.putPoint(scale, points);
        for (int i = 0; i < pp.size(); ++i) {
            list.add(new AnimationPoint(pp.get(i), rp.get(i), sp.get(i)));
        }
        return list;
    }

    @NotNull
    public static List<VectorPoint> putPoint(@NotNull List<VectorPoint> vectors, @NotNull Collection<Float> points) {
        if (vectors.isEmpty()) {
            return points.stream().map(t -> new VectorPoint(new Vector3f(), t.floatValue(), VectorInterpolation.LINEAR)).toList();
        }
        VectorPoint last = vectors.getLast();
        float length = last.time();
        int i = 0;
        VectorPoint p2 = vectors.getFirst();
        float t2 = p2.time();
        int lastIndex = vectors.size() - 1;
        ArrayList<VectorPoint> newVectors = new ArrayList<VectorPoint>();
        ArrayList<VectorPoint> finalizedVectors = new ArrayList<VectorPoint>();
        for (float point : points) {
            if (point > length) continue;
            while (i < lastIndex && t2 < point) {
                newVectors.add(p2);
                p2 = vectors.get(++i);
                t2 = p2.time();
            }
            if (t2 == point) continue;
            if (i == lastIndex && point >= t2) {
                finalizedVectors.add(new VectorPoint(last.vector(), point, last.interpolation()));
                continue;
            }
            newVectors.add(p2.interpolation().interpolate(vectors, i, point));
        }
        newVectors.addAll(vectors.subList(i, vectors.size()));
        newVectors.addAll(finalizedVectors);
        return newVectors;
    }

    public static float alpha(float p0, float p1, float alpha) {
        return alpha / (p0 + p1);
    }

    @NotNull
    public static Vector3f linear(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f((Vector3fc)p1).sub((Vector3fc)p0).mul(alpha).add((Vector3fc)p0);
    }

    public static float linear(float p0, float p1, float alpha) {
        return (p1 - p0) * alpha + p0;
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(0.5f * (2.0f * p1.x + (-p0.x + p2.x) * t + (2.0f * p0.x - 5.0f * p1.x + 4.0f * p2.x - p3.x) * t2 + (-p0.x + 3.0f * p1.x - 3.0f * p2.x + p3.x) * t3), 0.5f * (2.0f * p1.y + (-p0.y + p2.y) * t + (2.0f * p0.y - 5.0f * p1.y + 4.0f * p2.y - p3.y) * t2 + (-p0.y + 3.0f * p1.y - 3.0f * p2.y + p3.y) * t3), 0.5f * (2.0f * p1.z + (-p0.z + p2.z) * t + (2.0f * p0.z - 5.0f * p1.z + 4.0f * p2.z - p3.z) * t2 + (-p0.z + 3.0f * p1.z - 3.0f * p2.z + p3.z) * t3));
    }
}

