/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.List;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record AnimationMovement(float time, @Nullable Vector3f transform, @Nullable Vector3f scale, @Nullable Vector3f rotation) implements Comparable<AnimationMovement>
{
    @Override
    public int compareTo(@NotNull AnimationMovement o) {
        return Float.compare(this.time, o.time);
    }

    @NotNull
    public AnimationMovement set(float newTime) {
        if (newTime == this.time || this.time == 0.0f) {
            return this;
        }
        float mul = newTime / this.time;
        return new AnimationMovement(newTime, this.transform != null ? new Vector3f((Vector3fc)this.transform).mul(mul) : null, this.scale != null ? new Vector3f((Vector3fc)this.scale).mul(mul) : null, this.rotation != null ? new Vector3f((Vector3fc)this.rotation).mul(mul) : null);
    }

    @NotNull
    public AnimationMovement lerpTick() {
        if ((double)this.time % 0.05 == 0.0) {
            return this;
        }
        return this.set((float)Math.max(Math.round(this.time * 20.0f), 1) / 20.0f);
    }

    @NotNull
    public AnimationMovement lerp(@NotNull AnimationMovement to, float alpha) {
        if (alpha == 0.0f) {
            return this;
        }
        if (alpha == 1.0f) {
            return to;
        }
        return new AnimationMovement(to.time, MathUtil.lerp(this.transform, to.transform, alpha), MathUtil.lerp(this.scale, to.scale, alpha), MathUtil.lerp(this.rotation, to.rotation, alpha));
    }

    @NotNull
    public List<AnimationMovement> lerp(int lerpIndex, @NotNull AnimationMovement movement) {
        ArrayList<AnimationMovement> list = new ArrayList<AnimationMovement>();
        float m = 1.0f / (float)lerpIndex * movement.time();
        float r = movement.time();
        for (int i = 0; i < lerpIndex; ++i) {
            float t = (float)(i + 1) / (float)lerpIndex;
            AnimationMovement lerp = this.lerp(movement, t).time(Math.max(r % m, 0.05f)).lerpTick();
            list.add(lerp);
            r -= lerp.time();
        }
        return list;
    }

    @NotNull
    public AnimationMovement time(float newTime) {
        return new AnimationMovement(newTime, this.transform, this.scale, this.rotation);
    }

    @NotNull
    public AnimationMovement plus(@NotNull AnimationMovement other) {
        return new AnimationMovement(this.time + other.time, this.plus(this.transform, other.transform), this.plus(this.scale, other.scale), this.plus(this.rotation, other.rotation));
    }

    @NotNull
    public AnimationMovement minus(@NotNull AnimationMovement other) {
        return new AnimationMovement(this.time - other.time(), this.minus(this.transform, other.transform), this.minus(this.scale, other.scale), this.minus(this.rotation, other.rotation));
    }

    @NotNull
    public AnimationMovement copyNotNull() {
        return new AnimationMovement(this.time, this.transform != null ? new Vector3f((Vector3fc)this.transform) : new Vector3f(), this.scale != null ? new Vector3f((Vector3fc)this.scale) : new Vector3f(), this.rotation != null ? new Vector3f((Vector3fc)this.rotation) : new Vector3f());
    }

    @Nullable
    private Vector3f plus(@Nullable Vector3f one, @Nullable Vector3f two) {
        if (one != null && two != null) {
            return new Vector3f((Vector3fc)one).add((Vector3fc)two);
        }
        if (one != null) {
            return one;
        }
        return two;
    }

    @Nullable
    private Vector3f minus(@Nullable Vector3f one, @Nullable Vector3f two) {
        if (one != null && two != null) {
            return new Vector3f((Vector3fc)one).sub((Vector3fc)two);
        }
        if (one != null) {
            return one;
        }
        return two;
    }
}

