/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.BlueprintJson;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public sealed interface BlueprintChildren {
    public static BlueprintChildren from(@NotNull ModelChildren children, @NotNull @Unmodifiable Map<String, ModelElement> elementMap, float scale) {
        ModelChildren modelChildren = children;
        Objects.requireNonNull(modelChildren);
        ModelChildren modelChildren2 = modelChildren;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModelChildren.ModelGroup.class, ModelChildren.ModelUUID.class}, (Object)modelChildren2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ModelChildren.ModelGroup modelGroup = (ModelChildren.ModelGroup)modelChildren2;
                PackUtil.validatePath(modelGroup.name(), "Group name must be [a-z0-9/._-]: " + modelGroup.name());
                yield new BlueprintGroup(modelGroup.name(), modelGroup.origin(), modelGroup.rotation(), modelGroup.children().stream().map(c -> BlueprintChildren.from(c, elementMap, scale)).toList(), modelGroup.visibility());
            }
            case 1 -> {
                ModelChildren.ModelUUID modelUUID = (ModelChildren.ModelUUID)modelChildren2;
                yield new BlueprintElement(Objects.requireNonNull(elementMap.get(modelUUID.uuid())), scale);
            }
        };
    }

    public record BlueprintGroup(@NotNull String name, @NotNull Float3 origin, @NotNull Float3 rotation, @NotNull List<BlueprintChildren> children, boolean visibility) implements BlueprintChildren
    {
        @NotNull
        public String jsonName(@NotNull ModelBlueprint parent) {
            return parent.name().toLowerCase() + "_" + this.name.toLowerCase();
        }

        public BlueprintJson buildJson(@NotNull ModelBlueprint parent) {
            ArrayList<BlueprintElement> list = new ArrayList<BlueprintElement>();
            for (BlueprintChildren child : this.children) {
                if (!(child instanceof BlueprintElement)) continue;
                BlueprintElement element = (BlueprintElement)child;
                list.add(element);
            }
            return this.buildJson(-2, 1, parent, Float3.ZERO, list);
        }

        public List<BlueprintJson> buildModernJson(@NotNull ModelBlueprint parent) {
            ArrayList<BlueprintJson> list = new ArrayList<BlueprintJson>();
            HashMap<Float3, List> floatMap = new HashMap<Float3, List>();
            for (BlueprintChildren child : this.children) {
                if (!(child instanceof BlueprintElement)) continue;
                BlueprintElement element = (BlueprintElement)child;
                floatMap.computeIfAbsent(element.identifierDegree(), u -> new ArrayList()).add(element);
            }
            int i = 0;
            for (Map.Entry entry : floatMap.entrySet()) {
                list.add(this.buildJson(0, ++i, parent, (Float3)entry.getKey(), (List)entry.getValue()));
            }
            return list;
        }

        private BlueprintJson buildJson(int tint, int number, @NotNull ModelBlueprint parent, @NotNull Float3 identifier, @NotNull List<BlueprintElement> cubes) {
            JsonObject object = new JsonObject();
            JsonObject textureObject = new JsonObject();
            int index = 0;
            for (BlueprintTexture blueprintTexture : parent.textures()) {
                textureObject.addProperty(Integer.toString(index++), BetterModel.inst().configManager().namespace() + ":item/" + parent.name() + "_" + blueprintTexture.name());
            }
            object.add("textures", (JsonElement)textureObject);
            JsonArray elements = new JsonArray();
            for (BlueprintElement cube : cubes) {
                cube.buildJson(tint, parent, this, identifier, elements);
            }
            if (elements.isEmpty()) {
                return null;
            }
            object.add("elements", (JsonElement)elements);
            if (!identifier.equals(Float3.ZERO)) {
                JsonObject jsonObject = new JsonObject();
                JsonObject fixed = new JsonObject();
                fixed.add("rotation", (JsonElement)identifier.convertToMinecraftDegree().toJson());
                jsonObject.add("fixed", (JsonElement)fixed);
                object.add("display", (JsonElement)jsonObject);
            }
            return new BlueprintJson(this.jsonName(parent) + "_" + number, (JsonElement)object);
        }

        @Nullable
        public NamedBoundingBox hitBox() {
            ArrayList<ModelBoundingBox> elements = new ArrayList<ModelBoundingBox>();
            for (BlueprintChildren child : this.children) {
                if (!(child instanceof BlueprintElement)) continue;
                BlueprintElement element = (BlueprintElement)child;
                ModelElement model = element.element;
                Vector3f from = model.from().minus(this.origin).toVector().div(16.0f);
                Vector3f to = model.to().minus(this.origin).toVector().div(16.0f);
                elements.add(new ModelBoundingBox(from.x, from.y, from.z, to.x, to.y, to.z));
            }
            ModelBoundingBox max = EntityUtil.max(elements);
            return max != null ? new NamedBoundingBox(this.name, max) : null;
        }
    }

    public record BlueprintElement(@NotNull ModelElement element, float scale) implements BlueprintChildren
    {
        @NotNull
        private Float3 identifierDegree() {
            Float3 rot = this.element.rotation();
            return rot == null ? Float3.ZERO : MathUtil.identifier(rot);
        }

        @NotNull
        private Float3 centralize(@NotNull Float3 target, @NotNull Float3 groupOrigin) {
            return target.minus(groupOrigin).div(this.scale);
        }

        private void buildJson(int tint, @NotNull ModelBlueprint parent, @NotNull BlueprintGroup group, @NotNull Float3 identifier, @NotNull JsonArray targetArray) {
            if (!this.element.hasTexture()) {
                return;
            }
            Float3 centerOrigin = this.centralize(this.element.origin(), group.origin);
            Quaternionf qua = MathUtil.toQuaternion(identifier.toVector()).invert();
            Float3 rotOrigin = centerOrigin.rotate(qua).minus(centerOrigin);
            JsonObject object = new JsonObject();
            Float3 inflate = new Float3(this.element.inflate() / this.scale);
            object.add("from", (JsonElement)this.centralize(this.element.from(), group.origin).plus(rotOrigin).plus(Float3.CENTER).minus(inflate).toJson());
            object.add("to", (JsonElement)this.centralize(this.element.to(), group.origin).plus(rotOrigin).plus(Float3.CENTER).plus(inflate).toJson());
            Float3 rot = this.element.rotation();
            if (rot != null && !Float3.ZERO.equals(rot = rot.minus(identifier))) {
                JsonObject rotation = this.getRotation(rot);
                rotation.add("origin", (JsonElement)centerOrigin.plus(rotOrigin).plus(Float3.CENTER).toJson());
                object.add("rotation", (JsonElement)rotation);
            }
            object.add("faces", (JsonElement)this.element.faces().toJson(parent, tint));
            targetArray.add((JsonElement)object);
        }

        @NotNull
        private JsonObject getRotation(@NotNull Float3 rot) {
            JsonObject rotation = new JsonObject();
            if (Math.abs(rot.x()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.x()));
                rotation.addProperty("axis", "x");
            } else if (Math.abs(rot.y()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.y()));
                rotation.addProperty("axis", "y");
            } else if (Math.abs(rot.z()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.z()));
                rotation.addProperty("axis", "z");
            }
            return rotation;
        }
    }
}

