/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.NotNull;

public record BlueprintTexture(@NotNull String name, BufferedImage image, int uvWidth, int uvHeight) {
    @NotNull
    public static BlueprintTexture from(@NotNull ModelTexture blueprint) {
        BufferedImage image;
        PackUtil.validatePath(blueprint.name(), "Texture name must be [a-z0-9/._-]: " + blueprint.name());
        try (ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(blueprint.source().split(",")[1]));
             BufferedInputStream buffered = new BufferedInputStream(input);){
            image = ImageIO.read(buffered);
        }
        catch (Exception e) {
            throw new RuntimeException("image");
        }
        return new BlueprintTexture(blueprint.name().split("\\.")[0].toLowerCase(), image, blueprint.uvWidth(), blueprint.uvHeight());
    }

    public boolean isAnimatedTexture() {
        return this.uvHeight != 0 && this.uvWidth != 0 && this.image.getHeight() / this.uvHeight / Math.max(this.image.getWidth() / this.uvWidth, 1) > 1;
    }

    @NotNull
    public JsonObject toMcmeta() {
        JsonObject json = new JsonObject();
        JsonObject animation = new JsonObject();
        animation.addProperty("interpolate", Boolean.valueOf(true));
        animation.addProperty("frametime", (Number)10);
        json.add("animation", (JsonElement)animation);
        return json;
    }

    @NotNull
    public ModelResolution resolution() {
        return new ModelResolution(this.uvWidth, this.uvHeight);
    }
}

