/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.script.EntityScript;
import kr.toxicity.model.api.script.TimeScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlueprintScript(@NotNull String name, int length, @NotNull List<TimeScript> scripts) {
    @NotNull
    public static BlueprintScript emptyOf(@NotNull ModelAnimation animation) {
        return new BlueprintScript(animation.name(), 0, Collections.emptyList());
    }

    @NotNull
    public static BlueprintScript from(@NotNull ModelAnimation animation, @NotNull ModelAnimator animator) {
        return new BlueprintScript(animation.name(), Math.round((animation.length() - (float)animator.keyframes().stream().mapToDouble(ModelKeyframe::time).max().orElse(0.0)) * 20.0f), BlueprintScript.processFrame(animator.keyframes()).stream().map(d -> EntityScript.of(d.dataPoints().stream().map(p -> {
            String raw = p.script();
            if (raw == null) {
                return null;
            }
            return BetterModel.inst().scriptManager().build(raw);
        }).filter(Objects::nonNull).toList()).time(Math.round(d.time() * 20.0f))).toList());
    }

    @NotNull
    public ScriptReader single(int delay, float speed) {
        return new SingleScriptReader(delay, speed);
    }

    @NotNull
    public ScriptReader loop(int delay, float speed) {
        return new LoopScriptReader(delay, speed);
    }

    @NotNull
    private static List<ModelKeyframe> processFrame(@NotNull List<ModelKeyframe> target) {
        if (target.size() <= 1) {
            return target;
        }
        ArrayList<ModelKeyframe> list = new ArrayList<ModelKeyframe>();
        for (int i = 1; i < target.size(); ++i) {
            ModelKeyframe get = target.get(i);
            list.add(get.time(get.time() - target.get(i - 1).time()));
        }
        return list;
    }

    private class SingleScriptReader
    implements ScriptReader {
        private final int initialDelay;
        private int index;
        private int delay;
        private final float speed;
        @Nullable
        private EntityScript script;

        private SingleScriptReader(int initialDelay, float speed) {
            this.initialDelay = this.delay = initialDelay;
            this.speed = speed;
        }

        @Override
        public void clear() {
            this.index = 0;
            this.delay = this.initialDelay;
        }

        @Override
        public boolean tick() {
            if (--this.delay <= 0) {
                if (this.index >= BlueprintScript.this.scripts.size()) {
                    return true;
                }
                TimeScript next = BlueprintScript.this.scripts.get(this.index++);
                this.delay = Math.round((float)next.time() / this.speed);
                this.script = next.script();
            } else {
                this.script = null;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityScript script() {
            return this.script;
        }
    }

    private class LoopScriptReader
    implements ScriptReader {
        private final int initialDelay;
        private int index;
        private int delay;
        private final float speed;
        @Nullable
        private EntityScript script;

        private LoopScriptReader(int initialDelay, float speed) {
            this.initialDelay = this.delay = initialDelay;
            this.speed = speed;
        }

        @Override
        public void clear() {
            this.index = 0;
            this.delay = this.initialDelay;
        }

        @Override
        public boolean tick() {
            if (--this.delay <= 0) {
                if (this.index >= BlueprintScript.this.scripts.size()) {
                    this.delay = Math.round((float)BlueprintScript.this.length / this.speed);
                    this.index = 0;
                    this.script = null;
                    return false;
                }
                TimeScript next = BlueprintScript.this.scripts.get(this.index++);
                this.delay = Math.round((float)(next.time() * 20) / this.speed);
                this.script = next.script();
            } else {
                this.script = null;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityScript script() {
            return this.script;
        }
    }

    public static interface ScriptReader {
        public boolean tick();

        public void clear();

        @Nullable
        public EntityScript script();
    }
}

