/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.Set;
import kr.toxicity.model.api.data.raw.Float3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class MathUtil {
    public static final float ROTATION_DEGREE = 22.5f;
    public static final Set<Float> VALID_ROTATION_DEGREES = Set.of(Float.valueOf(0.0f), Float.valueOf(22.5f), Float.valueOf(45.0f), Float.valueOf(-22.5f), Float.valueOf(-45.0f));

    private MathUtil() {
        throw new RuntimeException();
    }

    public static boolean checkValidDegree(@NotNull Float3 rotation) {
        int i = 0;
        if (rotation.x() != 0.0f) {
            ++i;
        }
        if (rotation.y() != 0.0f) {
            ++i;
        }
        if (rotation.z() != 0.0f) {
            ++i;
        }
        return i < 2 && MathUtil.checkValidDegree(rotation.x()) && MathUtil.checkValidDegree(rotation.y()) && MathUtil.checkValidDegree(rotation.z());
    }

    public static boolean checkValidDegree(float rotation) {
        return VALID_ROTATION_DEGREES.contains(Float.valueOf(rotation));
    }

    @NotNull
    public static Float3 identifier(@NotNull Float3 rotation) {
        if (MathUtil.checkValidDegree(rotation)) {
            return Float3.ZERO;
        }
        return rotation;
    }

    private static float createIdentifier(float value) {
        float abs = Math.abs(value);
        if (abs >= 22.5f) {
            abs -= 22.5f;
        }
        if (abs >= 22.5f) {
            abs -= 22.5f;
        }
        return (float)(value > 0.0f ? 1 : -1) * abs;
    }

    @NotNull
    public static Vector3f animationToDisplay(@NotNull Vector3f vector) {
        return new Vector3f(-vector.x, -vector.y, vector.z);
    }

    @NotNull
    public static Vector3f transformToDisplay(@NotNull Vector3f vector) {
        return new Vector3f(vector.x, vector.y, -vector.z);
    }

    @NotNull
    public static Vector3f blockBenchToDisplay(@NotNull Vector3f vector) {
        return new Vector3f(-vector.x, vector.y, -vector.z);
    }

    @NotNull
    public static Quaternionf toQuaternion(@NotNull Vector3f vector) {
        Vector3f rotate = MathUtil.toRadians(vector);
        float roll = rotate.x;
        float pitch = rotate.y;
        float yaw = rotate.z;
        double cr = Math.cos((double)roll * 0.5);
        double sr = Math.sin((double)roll * 0.5);
        double cp = Math.cos((double)pitch * 0.5);
        double sp = Math.sin((double)pitch * 0.5);
        double cy = Math.cos((double)yaw * 0.5);
        double sy = Math.sin((double)yaw * 0.5);
        Quaternionf q = new Quaternionf();
        q.w = (float)(cr * cp * cy + sr * sp * sy);
        q.x = (float)(sr * cp * cy - cr * sp * sy);
        q.y = (float)(cr * sp * cy + sr * cp * sy);
        q.z = (float)(cr * cp * sy - sr * sp * cy);
        return q;
    }

    @Nullable
    public static Vector3f lerp(@Nullable Vector3f from, @Nullable Vector3f to, float alpha) {
        if (to == null) {
            to = new Vector3f();
        }
        if (from == null) {
            from = new Vector3f();
        }
        return new Vector3f((Vector3fc)from).add((Vector3fc)new Vector3f((Vector3fc)to).sub((Vector3fc)from).mul(alpha));
    }

    @NotNull
    public static Vector3f toRadians(@NotNull Vector3f vector) {
        return new Vector3f((Vector3fc)vector).div(180.0f).mul((float)Math.PI);
    }

    @NotNull
    public static Vector3f toDegrees(@NotNull Vector3f vector) {
        return new Vector3f((Vector3fc)vector).mul(180.0f).div((float)Math.PI);
    }

    @NotNull
    public static Vector3f toMinecraftVector(@NotNull Vector3f vec) {
        return MathUtil.toXYZEuler(MathUtil.toQuaternion(vec));
    }

    @NotNull
    public static Matrix3f toMatrix(@NotNull Quaternionf quaternion) {
        return quaternion.get(new Matrix3f());
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Quaternionf quaternion) {
        return MathUtil.toXYZEuler(MathUtil.toMatrix(quaternion));
    }

    public static float degree(@NotNull Quaternionf quaternionf) {
        return (float)Math.toDegrees(quaternionf.angle());
    }

    public static Vector3f toXYZEuler(Matrix3f mat) {
        Vector3f ret = new Vector3f();
        if (Math.abs(mat.m20) < 1.0f) {
            ret.x = (float)Math.atan2(-mat.m21, mat.m22);
            ret.z = (float)Math.atan2(-mat.m10, mat.m00);
        } else {
            ret.x = (float)Math.atan2(mat.m12, mat.m11);
            ret.z = 0.0f;
        }
        ret.y = (float)Math.asin(Math.clamp(mat.m20, -1.0f, 1.0f));
        return MathUtil.toDegrees(ret);
    }
}

