/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.BlueprintRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.manager.ConfigManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.ByteStreamsKt;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\b*\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\f\u0010\u001b\u001a\u00020\f*\u00020\u001cH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkr/toxicity/model/manager/PlayerManagerImpl;", "Lkr/toxicity/model/api/manager/PlayerManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/model/api/nms/PlayerChannelHandler;", "renderMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/data/renderer/BlueprintRenderer;", "start", "", "showAll", "Lorg/bukkit/entity/Player;", "register", "reload", "limbs", "", "limb", "name", "animate", "player", "model", "animation", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "uuid", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1611#2,9:124\n1863#2:133\n1864#2:135\n1620#2:136\n1863#2,2:137\n1611#2,9:139\n1863#2:148\n1864#2:150\n1620#2:151\n1#3:134\n1#3:149\n*S KotlinDebug\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n*L\n114#1:124,9\n114#1:133\n114#1:135\n114#1:136\n53#1:137,2\n105#1:139,9\n105#1:148\n105#1:150\n105#1:151\n114#1:134\n105#1:149\n*E\n"})
public final class PlayerManagerImpl
implements PlayerManager,
GlobalManagerImpl {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, BlueprintRenderer> renderMap = new HashMap();

    private PlayerManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void join(PlayerJoinEvent $this$join) {
                Intrinsics.checkNotNullParameter($this$join, "<this>");
                Player player = $this$join.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player);
                Player player2 = $this$join.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                PlayerManagerImpl.access$showAll(PlayerManagerImpl.INSTANCE, player2);
            }

            @EventHandler
            public final void change(PlayerChangedWorldEvent $this$change) {
                Intrinsics.checkNotNullParameter($this$change, "<this>");
                Player player = $this$change.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player).unregisterAll();
                Player player2 = $this$change.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                PlayerManagerImpl.access$showAll(PlayerManagerImpl.INSTANCE, player2);
            }

            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$quit, "<this>");
                    PlayerChannelHandler playerChannelHandler = (PlayerChannelHandler)PlayerManagerImpl.access$getPlayerMap$p().remove($this$quit.getPlayer().getUniqueId());
                    if (playerChannelHandler == null) break block0;
                    playerChannelHandler.close();
                }
            }
        });
    }

    private final void showAll(Player $this$showAll) {
        Location location = $this$showAll.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location loc = location;
        PluginsKt.getPLUGIN().scheduler().taskLater(10L, loc, () -> PlayerManagerImpl.showAll$lambda$1(loc, $this$showAll));
    }

    private final PlayerChannelHandler register(Player $this$register) {
        PlayerChannelHandler playerChannelHandler = playerMap.computeIfAbsent($this$register.getUniqueId(), arg_0 -> PlayerManagerImpl.register$lambda$3(arg_0 -> PlayerManagerImpl.register$lambda$2($this$register, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(playerChannelHandler, "computeIfAbsent(...)");
        return playerChannelHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        renderMap.clear();
        if (ConfigManagerImpl.INSTANCE.module().playerAnimation()) {
            File folder = new File(PluginsKt.getDATA_FOLDER(), "players");
            if (!folder.exists()) {
                folder.mkdirs();
                InputStream inputStream = PluginsKt.getPLUGIN().getResource("steve.bbmodel");
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    int n = 8192;
                    closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                    Throwable throwable = null;
                    try {
                        long l;
                        BufferedInputStream input = (BufferedInputStream)closeable;
                        boolean bl = false;
                        Closeable closeable2 = new FileOutputStream(new File(folder, "steve.bbmodel"));
                        int n2 = 8192;
                        closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2);
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream output = (BufferedOutputStream)closeable2;
                            boolean bl2 = false;
                            l = ByteStreamsKt.copyTo$default(input, output, 0, 2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable2);
                        }
                        Long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            }
            kr.toxicity.model.util.FilesKt.forEachAllFolder(folder, PlayerManagerImpl::reload$lambda$6);
        }
    }

    @Override
    @NotNull
    public List<BlueprintRenderer> limbs() {
        Collection<BlueprintRenderer> collection = renderMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @Nullable
    public BlueprintRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return renderMap.get(name);
    }

    @Override
    public void animate(@NotNull Player player, @NotNull String model, @NotNull String animation) {
        block2: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(model, "model");
            Intrinsics.checkNotNullParameter(animation, "animation");
            BlueprintRenderer blueprintRenderer = renderMap.get(model);
            if (blueprintRenderer == null) break block2;
            BlueprintRenderer it = blueprintRenderer;
            boolean bl = false;
            EntityTracker entityTracker = EntityTracker.tracker(player.getUniqueId());
            if (entityTracker != null) {
                entityTracker.close();
            }
            EntityTracker entityTracker2 = it.createPlayerLimb(player);
            Intrinsics.checkNotNullExpressionValue(entityTracker2, "createPlayerLimb(...)");
            EntityTracker create = entityTracker2;
            create.spawnNearby(player.getLocation());
            if (!create.animateSingle(animation, AnimationModifier.DEFAULT, () -> PlayerManagerImpl.animate$lambda$8$lambda$7(create))) {
                create.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BlueprintRenderer toRenderer(ModelBlueprint $this$toRenderer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<BlueprintChildren> list = $this$toRenderer.group();
        Intrinsics.checkNotNullExpressionValue(list, "group(...)");
        Iterable iterable = list;
        ModelBlueprint modelBlueprint = $this$toRenderer;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<String, RendererGroup> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlueprintChildren it = (BlueprintChildren)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof BlueprintChildren.BlueprintGroup ? TuplesKt.to(((BlueprintChildren.BlueprintGroup)it).name(), PlayerManagerImpl.toRenderer$parse((BlueprintChildren.BlueprintGroup)it, $this$toRenderer)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
        Map<String, RendererGroup> map2 = MapsKt.toMap((List)destination$iv$iv);
        ModelBlueprint modelBlueprint2 = modelBlueprint;
        return new BlueprintRenderer(modelBlueprint2, map2, map);
    }

    @Override
    @Nullable
    public PlayerChannelHandler player(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return playerMap.get(uuid);
    }

    @Override
    @NotNull
    public PlayerChannelHandler player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.register(player);
    }

    @Override
    public void end() {
        GlobalManagerImpl.DefaultImpls.end(this);
    }

    private static final void showAll$lambda$1(Location $loc, Player $this_showAll) {
        Collection collection = $loc.getWorld().getNearbyEntities($loc, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            EntityTracker entityTracker = EntityTracker.tracker(it);
            if (entityTracker == null) continue;
            entityTracker.spawn($this_showAll);
        }
    }

    private static final PlayerChannelHandler register$lambda$2(Player $this_register, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return PluginsKt.getPLUGIN().nms().inject($this_register);
    }

    private static final PlayerChannelHandler register$lambda$3(Function1 $tmp0, Object p0) {
        return (PlayerChannelHandler)$tmp0.invoke(p0);
    }

    private static final Unit reload$lambda$6(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(FilesKt.getExtension(it), "bbmodel")) {
            ModelBlueprint load = GsonsKt.toModel(it);
            ((Map)renderMap).put(load.name(), INSTANCE.toRenderer(load));
        }
        return Unit.INSTANCE;
    }

    private static final void animate$lambda$8$lambda$7(EntityTracker $create) {
        $create.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final RendererGroup toRenderer$parse(BlueprintChildren.BlueprintGroup $this$toRenderer_u24parse, ModelBlueprint $this_toRenderer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        String string = $this$toRenderer_u24parse.name();
        float f = (float)$this_toRenderer.scale();
        ItemStack itemStack = new ItemStack(Material.AIR);
        List<BlueprintChildren> list = $this$toRenderer_u24parse.children();
        Intrinsics.checkNotNullExpressionValue(list, "children(...)");
        Iterable iterable = list;
        BlueprintChildren.BlueprintGroup blueprintGroup = $this$toRenderer_u24parse;
        ItemStack itemStack2 = itemStack;
        float f2 = f;
        String string2 = string;
        boolean $i$f$mapNotNull = false;
        void var4_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<String, RendererGroup> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlueprintChildren it = (BlueprintChildren)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof BlueprintChildren.BlueprintGroup ? TuplesKt.to(((BlueprintChildren.BlueprintGroup)it).name(), PlayerManagerImpl.toRenderer$parse((BlueprintChildren.BlueprintGroup)it, $this_toRenderer)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Map<String, RendererGroup> map = MapsKt.toMap(list2);
        NamedBoundingBox namedBoundingBox = $this$toRenderer_u24parse.hitBox();
        String string3 = $this$toRenderer_u24parse.name();
        Intrinsics.checkNotNullExpressionValue(string3, "name(...)");
        PlayerLimb playerLimb = GsonsKt.toLimb(string3);
        NamedBoundingBox namedBoundingBox2 = namedBoundingBox;
        Map<String, RendererGroup> map2 = map;
        BlueprintChildren.BlueprintGroup blueprintGroup2 = blueprintGroup;
        ItemStack itemStack3 = itemStack2;
        float f3 = f2;
        String string4 = string2;
        return new RendererGroup(string4, f3, itemStack3, blueprintGroup2, map2, namedBoundingBox2, playerLimb);
    }

    public static final /* synthetic */ PlayerChannelHandler access$register(PlayerManagerImpl $this, Player $receiver) {
        return $this.register($receiver);
    }

    public static final /* synthetic */ void access$showAll(PlayerManagerImpl $this, Player $receiver) {
        $this.showAll($receiver);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerMap$p() {
        return playerMap;
    }
}

