/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIBukkit;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIHandler;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.Argument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.GreedyArgument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.PreviewInfo;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.Previewable;
import kr.toxicity.model.shaded.dev.jorel.commandapi.commandsenders.BukkitPlayer;
import kr.toxicity.model.shaded.dev.jorel.commandapi.exceptions.PaperAdventureNotFoundException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.executors.CommandArguments;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.PreviewableFunction;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdventureChatArgument
extends Argument<Component>
implements GreedyArgument,
Previewable<AdventureChatArgument, Component> {
    private PreviewableFunction<Component> preview;
    private boolean usePreview;

    public AdventureChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("net.kyori.adventure.text.Component");
        }
        catch (ClassNotFoundException e) {
            throw new PaperAdventureNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<Component> getPrimitiveType() {
        return Component.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ADVENTURE_CHAT;
    }

    @Override
    public <CommandSourceStack> Component parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        Component component = CommandAPIBukkit.get().getAdventureChat(cmdCtx, key);
        Optional<PreviewableFunction<Component>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                Component previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<Component>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public AdventureChatArgument withPreview(PreviewableFunction<Component> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<Component>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public AdventureChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

