/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.function.Supplier;
import kr.toxicity.model.api.util.FunctionUtil;
import org.jetbrains.annotations.NotNull;

public record AnimationModifier(@NotNull Supplier<Boolean> predicate, int start, int end, @NotNull SpeedModifier speed) {
    public static final AnimationModifier DEFAULT = new AnimationModifier(() -> true, 1, 0, 1.0f);
    public static final AnimationModifier DEFAULT_LOOP = new AnimationModifier(() -> true, 4, 0, 1.0f);

    public AnimationModifier(@NotNull Supplier<Boolean> predicate, int start2, int end, float speed) {
        this(predicate, start2, end, AnimationModifier.speed(speed));
    }

    public AnimationModifier(@NotNull Supplier<Boolean> predicate, int start2, int end, @NotNull Supplier<Float> supplier) {
        this(predicate, start2, end, new SpeedModifier(supplier));
    }

    public AnimationModifier(@NotNull Supplier<Boolean> predicate, int start2, int end, @NotNull SpeedModifier speed) {
        this.predicate = FunctionUtil.throttleTick(predicate);
        this.start = start2;
        this.end = end;
        this.speed = speed;
    }

    @NotNull
    public static SpeedModifier speed(float speed) {
        return new SpeedModifier(speed);
    }

    @NotNull
    public static SpeedModifier speed(@NotNull Supplier<Float> supplier) {
        return new SpeedModifier(supplier);
    }

    public float speedValue() {
        return this.speed.speed();
    }

    public record SpeedModifier(@NotNull Supplier<Float> supplier) {
        public SpeedModifier(@NotNull Supplier<Float> supplier) {
            this.supplier = FunctionUtil.throttleTick(supplier);
        }

        public SpeedModifier(float speed) {
            this(() -> Float.valueOf(speed));
        }

        public float speed() {
            return this.supplier.get().floatValue();
        }
    }
}

