/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.util.VectorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record BlueprintAnimation(@NotNull String name, float length, @NotNull @Unmodifiable Map<String, BlueprintAnimator> animator, @NotNull BlueprintScript script, @NotNull List<AnimationMovement> emptyAnimator) {
    @NotNull
    public static BlueprintAnimation from(@NotNull ModelAnimation animation) {
        HashMap<String, BlueprintAnimator.AnimatorData> map = new HashMap<String, BlueprintAnimator.AnimatorData>();
        BlueprintScript blueprintScript = BlueprintScript.emptyOf(animation);
        Map<String, ModelAnimator> animator = animation.animators();
        if (animator != null) {
            for (Map.Entry<String, ModelAnimator> entry : animator.entrySet()) {
                BlueprintAnimator.Builder builder = new BlueprintAnimator.Builder(animation.length());
                ArrayList<ModelKeyframe> frameList = new ArrayList<ModelKeyframe>(entry.getValue().keyframes());
                frameList.sort(Comparator.naturalOrder());
                for (ModelKeyframe keyframe : frameList) {
                    builder.addFrame(keyframe);
                }
                String name = entry.getValue().name();
                if (entry.getKey().equals("effects")) {
                    blueprintScript = BlueprintScript.from(animation, entry.getValue());
                    continue;
                }
                map.put(name, builder.build(name));
            }
        }
        Map<String, BlueprintAnimator> newMap = BlueprintAnimation.newMap(map);
        return new BlueprintAnimation(animation.name(), animation.length(), newMap, blueprintScript, newMap.isEmpty() ? List.of(new AnimationMovement(0.0f, null, null, null)) : newMap.values().iterator().next().keyFrame().stream().map(a -> new AnimationMovement(a.time(), null, null, null)).toList());
    }

    private static Map<String, BlueprintAnimator> newMap(@NotNull Map<String, BlueprintAnimator.AnimatorData> oldMap) {
        HashMap<String, BlueprintAnimator> newMap = new HashMap<String, BlueprintAnimator>();
        TreeSet<Float> floatSet = new TreeSet<Float>(Comparator.naturalOrder());
        oldMap.values().forEach(a -> a.points().stream().map(t -> Float.valueOf(t.position().time())).forEach(floatSet::add));
        for (Map.Entry<String, BlueprintAnimator.AnimatorData> entry : oldMap.entrySet()) {
            List<AnimationMovement> list = BlueprintAnimation.getAnimationMovements(floatSet, entry);
            newMap.put(entry.getKey(), new BlueprintAnimator(entry.getValue().name(), entry.getValue().length(), list));
        }
        return newMap;
    }

    @NotNull
    private static List<AnimationMovement> getAnimationMovements(Set<Float> floatSet, Map.Entry<String, BlueprintAnimator.AnimatorData> entry) {
        List<AnimationPoint> frame = entry.getValue().points();
        if (frame.isEmpty()) {
            return Collections.emptyList();
        }
        List<AnimationMovement> list = VectorUtil.putAnimationPoint(frame, floatSet).stream().map(AnimationPoint::toMovement).collect(Collectors.toList());
        return BlueprintAnimation.processFrame(list);
    }

    @NotNull
    private static List<AnimationMovement> processFrame(@NotNull List<AnimationMovement> target) {
        if (target.size() <= 1) {
            return target;
        }
        ArrayList<AnimationMovement> list = new ArrayList<AnimationMovement>();
        list.add(target.getFirst());
        for (int i = 1; i < target.size(); ++i) {
            AnimationMovement get = target.get(i);
            list.add(get.time(get.time() - target.get(i - 1).time()));
        }
        return list;
    }

    public BlueprintAnimator.AnimatorIterator emptyLoopIterator() {
        return new BlueprintAnimator.AnimatorIterator(){
            private int index = 0;

            @Override
            @NotNull
            public AnimationMovement first() {
                return BlueprintAnimation.this.emptyAnimator.getFirst();
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public void clear() {
                this.index = 0;
            }

            @Override
            public int lastIndex() {
                return BlueprintAnimation.this.emptyAnimator.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public AnimationMovement next() {
                if (this.index >= BlueprintAnimation.this.emptyAnimator.size()) {
                    this.index = 0;
                }
                return BlueprintAnimation.this.emptyAnimator.get(this.index++);
            }
        };
    }

    public BlueprintAnimator.AnimatorIterator emptySingleIterator() {
        return new BlueprintAnimator.AnimatorIterator(){
            private int index = 0;

            @Override
            @NotNull
            public AnimationMovement first() {
                return BlueprintAnimation.this.emptyAnimator.getFirst();
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public int lastIndex() {
                return BlueprintAnimation.this.emptyAnimator.size() - 1;
            }

            @Override
            public void clear() {
                this.index = Integer.MAX_VALUE;
            }

            @Override
            public boolean hasNext() {
                return this.index < BlueprintAnimation.this.emptyAnimator.size();
            }

            @Override
            public AnimationMovement next() {
                return BlueprintAnimation.this.emptyAnimator.get(this.index++);
            }
        };
    }
}

