/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import kr.toxicity.model.api.util.function.FloatConstantSupplier;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AnimationModifier(@NotNull BooleanSupplier predicate, int start, int end, @Nullable AnimationIterator.Type type, @NotNull FloatSupplier speed, @Nullable Boolean override) {
    public static final AnimationModifier DEFAULT = AnimationModifier.builder().build();
    public static final AnimationModifier DEFAULT_WITH_PLAY_ONCE = AnimationModifier.builder().type(AnimationIterator.Type.PLAY_ONCE).build();

    public AnimationModifier(int start2, int end, float speed) {
        this((BooleanSupplier)BooleanConstantSupplier.TRUE, start2, end, null, FloatConstantSupplier.of(speed));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, float speed) {
        this(predicate, start2, end, null, FloatConstantSupplier.of(speed));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @NotNull FloatSupplier supplier) {
        this(predicate, start2, end, null, supplier);
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, float speed) {
        this(predicate, start2, end, type, FloatConstantSupplier.of(speed), null);
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, @NotNull FloatSupplier speed) {
        this(predicate, start2, end, type, speed, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public AnimationIterator.Type type(@NotNull AnimationIterator.Type defaultType) {
        return this.type != null ? this.type : defaultType;
    }

    public float speedValue() {
        return this.speed.getAsFloat();
    }

    public boolean override(boolean original) {
        return this.override != null ? this.override : original;
    }

    public static final class Builder {
        private BooleanSupplier predicate = BooleanConstantSupplier.TRUE;
        private int start = 1;
        private int end = 0;
        private AnimationIterator.Type type = null;
        private FloatSupplier speed = FloatConstantSupplier.ONE;
        private Boolean override = null;

        private Builder() {
        }

        @NotNull
        public Builder predicate(@NotNull BooleanSupplier predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        @NotNull
        public Builder start(int start2) {
            this.start = start2;
            return this;
        }

        @NotNull
        public Builder end(int end) {
            this.end = end;
            return this;
        }

        @NotNull
        public Builder type(@Nullable AnimationIterator.Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder speed(@NotNull FloatSupplier speed) {
            this.speed = Objects.requireNonNull(speed);
            return this;
        }

        @NotNull
        public Builder override(@Nullable Boolean override) {
            this.override = override;
            return this;
        }

        @NotNull
        public AnimationModifier build() {
            return new AnimationModifier(this.predicate, this.start, this.end, this.type, this.speed, this.override);
        }
    }
}

