/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.HttpUtil;
import kr.toxicity.model.api.version.MinecraftVersion;
import kr.toxicity.model.command.CommandBuilder;
import kr.toxicity.model.command.CommandsKt;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.SetsKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.org.incendo.cloud.Command;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.data.MultipleEntitySelector;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser.PlayerParser;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser.location.LocationParser;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandContext;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandInput;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.standard.BooleanParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.standard.DoubleParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.standard.EnumParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.standard.StringParser;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.SuggestionProvider;
import kr.toxicity.model.util.EntitiesKt;
import kr.toxicity.model.util.FunctionsKt;
import kr.toxicity.model.util.PluginsKt;
import kr.toxicity.model.util.SendersKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u0012\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u0015\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkr/toxicity/model/manager/CommandManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "modelSuggestion", "Lkr/toxicity/model/shaded/org/incendo/cloud/suggestion/SuggestionProvider;", "Lorg/bukkit/command/CommandSender;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "limbSuggestion", "start", "", "hide", "context", "Lkr/toxicity/model/shaded/org/incendo/cloud/context/CommandContext;", "show", "disguise", "Lorg/bukkit/entity/Player;", "undisguise", "spawn", "version", "reload", "play", "test", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "end", "core"})
@SourceDebugExtension(value={"SMAP\nCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandManager.kt\nkr/toxicity/model/manager/CommandManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Commands.kt\nkr/toxicity/model/command/CommandsKt\n+ 4 Senders.kt\nkr/toxicity/model/util/SendersKt\n+ 5 Senders.kt\nkr/toxicity/model/util/SendersKt$toComponent$1\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1869#2,2:291\n1869#2,2:293\n1563#2:317\n1634#2,3:318\n27#3,3:295\n35#3:298\n27#3,3:299\n36#3:302\n36#3:303\n37#3:304\n23#3,3:305\n31#3:308\n36#3:309\n35#3:310\n27#3,3:311\n31#3:314\n37#3:315\n37#3:316\n30#4:321\n49#4,4:322\n49#4,4:328\n49#4,4:332\n30#4:336\n49#4,4:337\n30#4:341\n49#4,4:342\n51#4:347\n30#4:348\n49#4,4:349\n30#4:353\n49#4,4:354\n51#4:359\n30#4:360\n49#4,4:361\n30#4:366\n49#4,4:367\n30#5:326\n30#5:346\n30#5:358\n30#5:365\n30#5:371\n1#6:327\n*S KotlinDebug\n*F\n+ 1 CommandManager.kt\nkr/toxicity/model/manager/CommandManager\n*L\n149#1:291,2\n160#1:293,2\n97#1:317\n97#1:318,3\n168#1:295,3\n173#1:298\n181#1:299,3\n182#1:302\n183#1:303\n184#1:304\n255#1:305,3\n256#1:308\n257#1:309\n258#1:310\n269#1:311,3\n270#1:314\n271#1:315\n272#1:316\n207#1:321\n207#1:322,4\n208#1:328,4\n209#1:332,4\n225#1:336\n225#1:337,4\n227#1:341\n227#1:342,4\n225#1:347\n229#1:348\n229#1:349,4\n231#1:353\n231#1:354,4\n229#1:359\n241#1:360\n241#1:361,4\n242#1:366\n242#1:367,4\n207#1:326\n227#1:346\n231#1:358\n241#1:365\n242#1:371\n*E\n"})
public final class CommandManager
implements GlobalManager {
    @NotNull
    public static final CommandManager INSTANCE = new CommandManager();
    @NotNull
    private static final SuggestionProvider<CommandSender> modelSuggestion;
    @NotNull
    private static final SuggestionProvider<CommandSender> limbSuggestion;

    private CommandManager() {
    }

    @Override
    public void start() {
        String[] stringArray = new String[]{"bm", "model"};
        CommandsKt.command("bettermodel", "BetterModel's main command.", stringArray, (Function1<? super CommandBuilder, Unit>)((Function1)CommandManager::start$lambda$0));
    }

    private final void hide(CommandContext<CommandSender> context) {
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        CommandSender sender = (CommandSender)object;
        Object object2 = context.get("model");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String model2 = (String)object2;
        Object object3 = context.get("player");
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Player player = (Player)object3;
        boolean success = false;
        Collection collection = ((MultipleEntitySelector)context.get("entities")).values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Object object4 = EntitiesKt.toRegistry(it);
            boolean bl2 = object4 != null && (object4 = ((EntityTrackerRegistry)object4).tracker(model2)) != null ? ((Tracker)object4).hide(player) : false;
            if (!bl2) continue;
            success = true;
        }
        if (!success) {
            SendersKt.warn(SendersKt.audience(sender), "Failed to hide any of provided entities.");
        }
    }

    private final void show(CommandContext<CommandSender> context) {
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        CommandSender sender = (CommandSender)object;
        Object object2 = context.get("model");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String model2 = (String)object2;
        Object object3 = context.get("player");
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Player player = (Player)object3;
        boolean success = false;
        Collection collection = ((MultipleEntitySelector)context.get("entities")).values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Object object4 = EntitiesKt.toRegistry(it);
            boolean bl2 = object4 != null && (object4 = ((EntityTrackerRegistry)object4).tracker(model2)) != null ? ((Tracker)object4).show(player) : false;
            if (!bl2) continue;
            success = true;
        }
        if (!success) {
            SendersKt.warn(SendersKt.audience(sender), "Failed to show any of provided entities.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void disguise(CommandContext<Player> context) {
        void $this$model$iv;
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        Player player = (Player)object;
        CommandContext<Player> commandContext = context;
        String key$iv = "model";
        boolean $i$f$model = false;
        Function1 function1 = CommandsKt.model.1.INSTANCE;
        ModelRenderer modelRenderer = $this$model$iv.optional(key$iv).flatMap(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }).orElse(null);
        if (modelRenderer == null) {
            String it = key$iv;
            boolean bl = false;
            SendersKt.warn(SendersKt.audience((CommandSender)player), "Unable to find this model: " + it);
            return;
        }
        modelRenderer.getOrCreate((Entity)player);
    }

    /*
     * WARNING - void declaration
     */
    private final void undisguise(CommandContext<Player> context) {
        void $this$nullable$iv;
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        Player player = (Player)object;
        CommandContext<Player> commandContext = context;
        String key$iv = "model";
        boolean $i$f$nullable = false;
        String model2 = $this$nullable$iv.optional(key$iv).orElse(null);
        if (model2 != null) {
            EntityTracker entityTracker = EntitiesKt.toTracker((Entity)player, model2);
            if (entityTracker != null) {
                entityTracker.close();
            } else {
                SendersKt.warn(SendersKt.audience((CommandSender)player), "Cannot find this model to undisguise: " + model2);
            }
        } else {
            EntityTrackerRegistry entityTrackerRegistry = EntitiesKt.toRegistry((Entity)player);
            if (entityTrackerRegistry != null) {
                entityTrackerRegistry.close();
            } else {
                SendersKt.warn(SendersKt.audience((CommandSender)player), "Cannot find any model to undisguise");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawn(CommandContext<Player> context) {
        block13: {
            Player player;
            block12: {
                Entity entity;
                Object object;
                Entity entity22;
                Location loc;
                void $this$nullable$iv;
                void key$iv;
                void $this$nullable$iv2;
                void key$iv2;
                void $this$nullable$iv3;
                void $this$model$iv;
                Object object2 = context.sender();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sender(...)");
                player = (Player)object2;
                CommandContext<Player> commandContext = context;
                CommandContext<Player> key$iv3 = "model";
                boolean $i$f$model22 = false;
                Function1 function1 = CommandsKt.model.1.INSTANCE;
                ModelRenderer modelRenderer = $this$model$iv.optional((String)key$iv3).flatMap(new /* invalid duplicate definition of identical inner class */).orElse(null);
                if (modelRenderer == null) {
                    CommandContext<Player> it = key$iv3;
                    boolean bl = false;
                    SendersKt.warn(SendersKt.audience((CommandSender)player), "Unable to find this model: " + it);
                    return;
                }
                ModelRenderer model2 = modelRenderer;
                key$iv3 = context;
                String $i$f$model22 = "type";
                CommandContext<Player> ifNotFound$iv = EntityType.HUSK;
                boolean $i$f$nullable22 = false;
                CommandContext<Player> commandContext2 = $this$nullable$iv3.optional((String)key$iv2).orElse(null);
                if (commandContext2 == null) {
                    commandContext2 = ifNotFound$iv;
                }
                EntityType type = (EntityType)commandContext2;
                ifNotFound$iv = context;
                String $i$f$nullable22 = "scale";
                CommandContext<Player> ifNotFound$iv2 = Double.valueOf(1.0);
                boolean $i$f$nullable = false;
                CommandContext<Player> commandContext3 = $this$nullable$iv2.optional((String)key$iv).orElse(null);
                if (commandContext3 == null) {
                    commandContext3 = ifNotFound$iv2;
                }
                double scale2 = ((Number)commandContext3).doubleValue();
                ifNotFound$iv2 = context;
                String key$iv4 = "location";
                boolean $i$f$nullable3 = false;
                Location location = $this$nullable$iv.optional(key$iv4).orElse(null);
                if (location == null) {
                    boolean entity22 = false;
                    location = player.getLocation();
                }
                Intrinsics.checkNotNullExpressionValue(location, (String)"nullable(...)");
                Location $this$spawn_u24lambda_u242 = loc = (Location)location;
                boolean bl = false;
                World world = $this$spawn_u24lambda_u242.getWorld();
                if (world == null) {
                    world = player.getWorld();
                }
                Entity $this$spawn_u24lambda_u242_u240 = entity22 = world.spawnEntity($this$spawn_u24lambda_u242, type);
                boolean bl2 = false;
                if (PluginsKt.getPLUGIN().version().compareTo(MinecraftVersion.V1_21) >= 0 && $this$spawn_u24lambda_u242_u240 instanceof LivingEntity) {
                    AttributeInstance attributeInstance = ((LivingEntity)$this$spawn_u24lambda_u242_u240).getAttribute(EntitiesKt.getATTRIBUTE_SCALE());
                    if (attributeInstance != null) {
                        attributeInstance.setBaseValue(scale2);
                    }
                }
                Entity it = object = entity22;
                boolean bl3 = false;
                Object object3 = entity = it.isValid() ? object : null;
                if (entity == null) break block12;
                Entity entity3 = entity;
                boolean bl4 = false;
                object = model2.create(entity3);
                if (object != null) break block13;
            }
            SendersKt.warn(SendersKt.audience((CommandSender)player), "Entity spawning has been blocked.");
        }
    }

    private final void version(CommandContext<CommandSender> context) {
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        CommandSender sender = (CommandSender)object;
        Audience audience = SendersKt.audience(sender);
        SendersKt.info(audience, "Searching version, please wait...");
        PluginsKt.getPLUGIN().scheduler().asyncTask(() -> CommandManager.version$lambda$0(audience));
    }

    private final void reload(CommandContext<CommandSender> context) {
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        CommandSender sender = (CommandSender)object;
        Audience audience = SendersKt.audience(sender);
        PluginsKt.getPLUGIN().scheduler().asyncTask(() -> CommandManager.reload$lambda$0(audience, sender));
    }

    /*
     * WARNING - void declaration
     */
    private final void play(CommandContext<Player> context) {
        void $this$nullable$iv;
        CommandContext<Player> key$iv;
        void $this$nullable$iv2;
        void $this$string$iv;
        void $this$limb$iv;
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        Player player = (Player)object;
        Audience audience = SendersKt.audience((CommandSender)player);
        CommandContext<Player> commandContext = context;
        CommandContext<Player> key$iv2 = "limb";
        boolean $i$f$limb = false;
        Function1 function1 = CommandsKt.limb.1.INSTANCE;
        ModelRenderer modelRenderer = $this$limb$iv.optional((String)key$iv2).flatMap(new /* invalid duplicate definition of identical inner class */).orElse(null);
        if (modelRenderer == null) {
            CommandContext<Player> it = key$iv2;
            boolean bl = false;
            SendersKt.warn(audience, "Unable to find this limb: " + it);
            return;
        }
        ModelRenderer limb2 = modelRenderer;
        key$iv2 = context;
        CommandContext<Player> key$iv3 = "animation";
        boolean $i$f$string22 = false;
        Object object2 = $this$string$iv.get((String)key$iv3);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String it = (String)object2;
        boolean bl = false;
        BlueprintAnimation blueprintAnimation = limb2.animation(it).orElse(null);
        if (blueprintAnimation == null) {
            SendersKt.warn(audience, "Unable to find this animation: " + it);
            return;
        }
        BlueprintAnimation animation = blueprintAnimation;
        key$iv3 = context;
        String $i$f$string22 = "loop_type";
        AnimationIterator.Type ifNotFound$iv = AnimationIterator.Type.PLAY_ONCE;
        boolean $i$f$nullable = false;
        AnimationIterator.Type type = $this$nullable$iv2.optional((String)key$iv).orElse(null);
        if (type == null) {
            type = ifNotFound$iv;
        }
        AnimationIterator.Type loopType = type;
        key$iv = context;
        String key$iv4 = "hide";
        $i$f$nullable = false;
        boolean hide = !Intrinsics.areEqual($this$nullable$iv.optional(key$iv4).orElse(null), (Object)false);
        EntityTracker $this$play_u24lambda_u243 = limb2.getOrCreate((Entity)player, TrackerModifier.DEFAULT, arg_0 -> CommandManager.play$lambda$2(hide, arg_0));
        boolean bl2 = false;
        if (!$this$play_u24lambda_u243.animate(animation, new AnimationModifier(0, 0, loopType), $this$play_u24lambda_u243::close)) {
            $this$play_u24lambda_u243.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void test(CommandContext<CommandSender> context) {
        void $this$nullable$iv;
        void $this$nullable$iv2;
        void $this$string$iv;
        void $this$model$iv;
        Object object = context.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        CommandSender sender = (CommandSender)object;
        Audience audience = SendersKt.audience(sender);
        CommandContext<CommandSender> commandContext = context;
        CommandContext<CommandSender> key$iv = "model";
        boolean $i$f$model = false;
        Function1 function1 = CommandsKt.model.1.INSTANCE;
        ModelRenderer modelRenderer = $this$model$iv.optional((String)key$iv).flatMap(new /* invalid duplicate definition of identical inner class */).orElse(null);
        if (modelRenderer == null) {
            CommandContext<CommandSender> it = key$iv;
            boolean bl = false;
            SendersKt.warn(audience, "Unable to find this model: " + it);
            return;
        }
        ModelRenderer model2 = modelRenderer;
        key$iv = context;
        CommandContext<CommandSender> key$iv2 = "animation";
        boolean $i$f$string = false;
        Object object2 = $this$string$iv.get((String)key$iv2);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String str = (String)object2;
        boolean bl = false;
        BlueprintAnimation blueprintAnimation = model2.animation(str).orElse(null);
        if (blueprintAnimation == null) {
            SendersKt.warn(audience, "Unable to find this animation: " + str);
            return;
        }
        BlueprintAnimation animation = blueprintAnimation;
        key$iv2 = context;
        String key$iv3 = "player";
        boolean $i$f$nullable22 = false;
        Player player = $this$nullable$iv2.optional(key$iv3).orElse(null);
        if (player == null) {
            boolean bl2 = false;
            player = sender instanceof Player ? (Player)sender : null;
            if (player == null) {
                SendersKt.warn(audience, "Unable to find target player.");
                return;
            }
        }
        Player player2 = player;
        CommandContext<CommandSender> $i$f$nullable22 = context;
        String key$iv4 = "location";
        boolean $i$f$nullable = false;
        Location location = $this$nullable$iv.optional(key$iv4).orElse(null);
        if (location == null) {
            Location location2;
            boolean bl3 = false;
            Location $this$test_u24lambda_u243_u240 = location2 = player2.getLocation();
            boolean bl4 = false;
            $this$test_u24lambda_u243_u240.add(new Vector(0, 0, 10).rotateAroundY(-Math.toRadians($this$test_u24lambda_u243_u240.getYaw())));
            $this$test_u24lambda_u243_u240.setYaw($this$test_u24lambda_u243_u240.getYaw() + (float)180);
            location = location2;
        }
        Intrinsics.checkNotNullExpressionValue(location, (String)"nullable(...)");
        Location location3 = location;
        DummyTracker $this$test_u24lambda_u244 = model2.create(location3);
        boolean bl5 = false;
        $this$test_u24lambda_u244.spawn(player2);
        $this$test_u24lambda_u244.animate(animation, new AnimationModifier(0, 0, AnimationIterator.Type.PLAY_ONCE), $this$test_u24lambda_u244::close);
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
    }

    @Override
    public void end() {
    }

    private static final Iterable modelSuggestion$lambda$0(CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return BetterModel.modelKeys();
    }

    private static final Iterable limbSuggestion$lambda$0(CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return BetterModel.limbKeys();
    }

    private static final Unit start$lambda$0(CommandBuilder $this$command) {
        Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
        String[] stringArray = new String[]{"re", "rl"};
        $this$command.create("reload", "Reloads this plugin.", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$0));
        stringArray = new String[]{"s"};
        $this$command.create("spawn", "Summons some model to given type", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$1));
        stringArray = new String[]{"t"};
        $this$command.create("test", "Tests some model's animation to specific player", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$2));
        stringArray = new String[]{"d"};
        $this$command.create("disguise", "Disguises self.", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$3));
        stringArray = new String[]{"ud"};
        $this$command.create("undisguise", "Undisguises self.", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$4));
        stringArray = new String[]{"p"};
        $this$command.create("play", "Plays player animation", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$5));
        $this$command.create("hide", "Hides some entities from target player.", new String[0], (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$6));
        $this$command.create("show", "Shows some entities to target player.", new String[0], (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$7));
        stringArray = new String[]{"v"};
        $this$command.create("version", "Checks BetterModel's version", stringArray, (Function1<? super Command.Builder<CommandSender>, ? extends Command.Builder<? extends CommandSender>>)((Function1)CommandManager::start$lambda$0$8));
        return Unit.INSTANCE;
    }

    private static final Command.Builder start$lambda$0$0(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.handler(INSTANCE::reload);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Command.Builder start$lambda$0$1(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("model", StringParser.stringParser(), modelSuggestion).optional("type", EnumParser.enumParser(EntityType.class)).optional("scale", DoubleParser.doubleParser((double)0.0625, (double)16.0)).optional("location", LocationParser.locationParser()).senderType(Player.class).handler(INSTANCE::spawn);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Command.Builder start$lambda$0$2(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("model", StringParser.stringParser(), modelSuggestion).required("animation", StringParser.stringParser(), SuggestionProvider.blockingStrings(CommandManager::start$lambda$0$2$0)).optional("player", PlayerParser.playerParser()).optional("location", LocationParser.locationParser()).handler(INSTANCE::test);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Iterable start$lambda$0$2$0(CommandContext ctx, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Set set = (Set)CommandsKt.nullableString(ctx, "model", CommandManager::start$lambda$0$2$0$0);
        return set != null ? (Iterable)set : (Iterable)SetsKt.emptySet();
    }

    private static final Set start$lambda$0$2$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = BetterModel.modelOrNull(it);
        return object != null && (object = ((ModelRenderer)object).animations()) != null ? object.keySet() : null;
    }

    private static final Command.Builder start$lambda$0$3(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("model", StringParser.stringParser(), modelSuggestion).senderType(Player.class).handler(INSTANCE::disguise);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Command.Builder start$lambda$0$4(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.senderType(Player.class).optional("model", StringParser.stringParser(), SuggestionProvider.blockingStrings(CommandManager::start$lambda$0$4$0)).handler(INSTANCE::undisguise);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable start$lambda$0$4$0(CommandContext ctx, CommandInput commandInput) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Object object = ctx.sender();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender(...)");
        Object object2 = EntitiesKt.toRegistry((Entity)object);
        if (object2 != null && (object2 = ((EntityTrackerRegistry)object2).trackers()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Tracker tracker = (Tracker)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.name());
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    private static final Command.Builder start$lambda$0$5(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("limb", StringParser.stringParser(), limbSuggestion).required("animation", StringParser.stringParser(), SuggestionProvider.blockingStrings(CommandManager::start$lambda$0$5$0)).optional("loop_type", EnumParser.enumParser(AnimationIterator.Type.class)).optional("hide", BooleanParser.booleanParser()).senderType(Player.class).handler(INSTANCE::play);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Iterable start$lambda$0$5$0(CommandContext ctx, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Set set = (Set)CommandsKt.nullableString(ctx, "limb", CommandManager::start$lambda$0$5$0$0);
        return set != null ? (Iterable)set : (Iterable)SetsKt.emptySet();
    }

    private static final Set start$lambda$0$5$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = BetterModel.limbOrNull(it);
        return object != null && (object = ((ModelRenderer)object).animations()) != null ? object.keySet() : null;
    }

    private static final Command.Builder start$lambda$0$6(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("model", StringParser.stringParser(), modelSuggestion).required("player", PlayerParser.playerParser()).required("entities", MultipleEntitySelectorParser.multipleEntitySelectorParser()).handler(INSTANCE::hide);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Command.Builder start$lambda$0$7(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.required("model", StringParser.stringParser(), modelSuggestion).required("player", PlayerParser.playerParser()).required("entities", MultipleEntitySelectorParser.multipleEntitySelectorParser()).handler(INSTANCE::show);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    private static final Command.Builder start$lambda$0$8(Command.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Command.Builder builder = $this$create.handler(INSTANCE::version);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private static final void version$lambda$0(Audience $audience) {
        TextComponent.Builder builder;
        TextComponent.Builder builder2;
        TextComponent.Builder builder3;
        HttpUtil.LatestVersion version = PluginsKt.getLATEST_VERSION();
        ComponentLike[] componentLikeArray = new ComponentLike[4];
        componentLikeArray[0] = SendersKt.emptyComponentOf();
        String $this$toComponent_u24default$iv = "Current: " + PluginsKt.getPLUGIN().semver();
        boolean $i$f$toComponent2 = false;
        String content$iv$iv = $this$toComponent_u24default$iv;
        boolean $i$f$componentOf = false;
        boolean $i$f$componentOf2 = false;
        TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
        boolean bl = false;
        TextComponent.Builder builder4 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"content(...)");
        TextComponent.Builder builder5 = builder4;
        int n = 1;
        ComponentLike[] componentLikeArray2 = componentLikeArray;
        Audience audience = $audience;
        boolean bl2 = false;
        TextComponent.Builder builder6 = builder3 = builder5;
        Audience audience2 = audience;
        BuildableComponent buildableComponent = builder6.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
        componentLikeArray2[n] = (TextComponent)buildableComponent;
        ComponentLike[] componentLikeArray3 = componentLikeArray;
        int n2 = 2;
        HttpUtil.PluginVersion pluginVersion = version.release();
        if (pluginVersion != null) {
            void version2;
            HttpUtil.PluginVersion $i$f$toComponent2 = pluginVersion;
            n = n2;
            componentLikeArray2 = componentLikeArray3;
            audience = audience2;
            boolean bl3 = false;
            String content$iv = "Latest release: ";
            $i$f$componentOf2 = false;
            boolean $i$f$componentOf3 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv = SendersKt.componentOf();
            boolean bl4 = false;
            TextComponent.Builder builder7 = $this$componentOf_u24lambda_u241$iv.content(content$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"content(...)");
            TextComponent.Builder $this$version_u24lambda_u240_u240_u240 = builder7;
            boolean bl5 = false;
            ComponentBuilder componentBuilder = $this$version_u24lambda_u240_u240_u240.append(version2.toURLComponent());
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"append(...)");
            BuildableComponent buildableComponent2 = ((TextComponent.Builder)componentBuilder).build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent2, (String)"build(...)");
            builder6 = (TextComponent)buildableComponent2;
            audience2 = audience;
            componentLikeArray3 = componentLikeArray2;
            n2 = n;
            builder2 = builder6;
        } else {
            builder2 = null;
        }
        componentLikeArray3[n2] = builder2;
        ComponentLike[] componentLikeArray4 = componentLikeArray;
        int n3 = 3;
        HttpUtil.PluginVersion pluginVersion2 = version.snapshot();
        if (pluginVersion2 != null) {
            HttpUtil.PluginVersion version2 = pluginVersion2;
            n = n3;
            componentLikeArray2 = componentLikeArray4;
            audience = audience2;
            boolean bl6 = false;
            String content$iv = "Latest snapshot: ";
            $i$f$componentOf2 = false;
            boolean $i$f$componentOf4 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv = SendersKt.componentOf();
            boolean bl7 = false;
            TextComponent.Builder builder8 = $this$componentOf_u24lambda_u241$iv.content(content$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"content(...)");
            TextComponent.Builder $this$version_u24lambda_u240_u241_u240 = builder8;
            boolean bl8 = false;
            ComponentBuilder componentBuilder = $this$version_u24lambda_u240_u241_u240.append(version2.toURLComponent());
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"append(...)");
            BuildableComponent buildableComponent3 = ((TextComponent.Builder)componentBuilder).build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent3, (String)"build(...)");
            builder6 = (TextComponent)buildableComponent3;
            audience2 = audience;
            componentLikeArray4 = componentLikeArray2;
            n3 = n;
            builder = builder6;
        } else {
            builder = null;
        }
        componentLikeArray4[n3] = builder;
        SendersKt.infoNotNull(audience2, componentLikeArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final void reload$lambda$0(Audience $audience, CommandSender $sender) {
        SendersKt.info($audience, "Start reloading. please wait...");
        BetterModelPlugin.ReloadResult reloadResult = PluginsKt.getPLUGIN().reload($sender);
        Intrinsics.checkNotNullExpressionValue((Object)reloadResult, (String)"reload(...)");
        BetterModelPlugin.ReloadResult result = reloadResult;
        if (result instanceof BetterModelPlugin.ReloadResult.OnReload) {
            SendersKt.warn($audience, "This plugin is still on reload!");
        } else if (result instanceof BetterModelPlugin.ReloadResult.Success) {
            void $this$reload_u24lambda_u240_u241;
            TextComponent.Builder $this$reload_u24lambda_u240_u240;
            ComponentLike[] componentLikeArray = new ComponentLike[7];
            componentLikeArray[0] = SendersKt.emptyComponentOf();
            String string = "Reload completed. (" + FunctionsKt.withComma(((BetterModelPlugin.ReloadResult.Success)result).totalTime()) + "ms)";
            NamedTextColor namedTextColor = NamedTextColor.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"GREEN");
            componentLikeArray[1] = SendersKt.toComponent(string, (TextColor)namedTextColor);
            String $this$toComponent$iv = "Assets reload time - " + FunctionsKt.withComma(((BetterModelPlugin.ReloadResult.Success)result).assetsTime()) + "ms";
            boolean $i$f$toComponent = false;
            String content$iv$iv = $this$toComponent$iv;
            boolean $i$f$componentOf = false;
            boolean $i$f$componentOf2 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            boolean bl = false;
            TextComponent.Builder builder = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"content(...)");
            TextComponent.Builder builder2 = builder;
            int n = 2;
            ComponentLike[] componentLikeArray2 = componentLikeArray;
            Audience audience = $audience;
            boolean bl2 = false;
            $this$reload_u24lambda_u240_u240.color((TextColor)NamedTextColor.GRAY);
            String $this$toComponent_u24default$iv = "Reading all config and model.";
            boolean $i$f$toComponent2 = false;
            String content$iv$iv2 = $this$toComponent_u24default$iv;
            boolean $i$f$componentOf3 = false;
            boolean $i$f$componentOf4 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv2 = SendersKt.componentOf();
            $i$a$-componentOf-SendersKt$componentOf$2$iv$iv = false;
            TextComponent.Builder builder3 = $this$componentOf_u24lambda_u241$iv$iv2.content(content$iv$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"content(...)");
            TextComponent.Builder builder4 = builder3;
            void var21_37 = $this$reload_u24lambda_u240_u240;
            boolean bl3 = false;
            TextComponent.Builder builder5 = builder4;
            BuildableComponent buildableComponent = builder5.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            ComponentBuilder componentBuilder = var21_37.hoverEvent((HoverEventSource)SendersKt.toHoverEvent((ComponentLike)((TextComponent)buildableComponent)));
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"hoverEvent(...)");
            TextComponent.Builder builder6 = (TextComponent.Builder)componentBuilder;
            BuildableComponent buildableComponent2 = builder6.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent2, (String)"build(...)");
            componentLikeArray2[n] = (TextComponent)buildableComponent2;
            $this$toComponent$iv = "Packing time - " + FunctionsKt.withComma(((BetterModelPlugin.ReloadResult.Success)result).packingTime()) + "ms";
            $i$f$toComponent = false;
            content$iv$iv = $this$toComponent$iv;
            $i$f$componentOf = false;
            $i$f$componentOf2 = false;
            $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            bl = false;
            TextComponent.Builder builder7 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"content(...)");
            $this$reload_u24lambda_u240_u240 = builder7;
            n = 3;
            componentLikeArray2 = componentLikeArray;
            boolean bl4 = false;
            $this$reload_u24lambda_u240_u241.color((TextColor)NamedTextColor.GRAY);
            $this$toComponent_u24default$iv = "Packing all model to resource pack.";
            $i$f$toComponent2 = false;
            content$iv$iv2 = $this$toComponent_u24default$iv;
            $i$f$componentOf3 = false;
            $i$f$componentOf4 = false;
            $this$componentOf_u24lambda_u241$iv$iv2 = SendersKt.componentOf();
            $i$a$-componentOf-SendersKt$componentOf$2$iv$iv = false;
            TextComponent.Builder builder8 = $this$componentOf_u24lambda_u241$iv$iv2.content(content$iv$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"content(...)");
            builder5 = builder8;
            var21_37 = $this$reload_u24lambda_u240_u241;
            bl3 = false;
            BuildableComponent buildableComponent3 = builder5.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent3, (String)"build(...)");
            ComponentBuilder componentBuilder2 = var21_37.hoverEvent((HoverEventSource)SendersKt.toHoverEvent((ComponentLike)((TextComponent)buildableComponent3)));
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder2, (String)"hoverEvent(...)");
            builder6 = (TextComponent.Builder)componentBuilder2;
            BuildableComponent buildableComponent4 = builder6.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent4, (String)"build(...)");
            componentLikeArray2[n] = (TextComponent)buildableComponent4;
            String string2 = FunctionsKt.withComma(BetterModel.models().size()) + " of models are loaded successfully. (" + FunctionsKt.toByteFormat(((BetterModelPlugin.ReloadResult.Success)result).length()) + ")";
            NamedTextColor namedTextColor2 = NamedTextColor.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor2, (String)"YELLOW");
            componentLikeArray[4] = SendersKt.toComponent(string2, (TextColor)namedTextColor2);
            Object object = ((BetterModelPlugin.ReloadResult.Success)result).packResult().changed() ? FunctionsKt.withComma(((BetterModelPlugin.ReloadResult.Success)result).packResult().size()) + " of files are zipped." : "Zipping is skipped due to the same result.";
            NamedTextColor namedTextColor3 = NamedTextColor.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor3, (String)"YELLOW");
            componentLikeArray[5] = SendersKt.toComponent((String)object, (TextColor)namedTextColor3);
            componentLikeArray[6] = SendersKt.emptyComponentOf();
            SendersKt.info(audience, componentLikeArray);
        } else if (result instanceof BetterModelPlugin.ReloadResult.Failure) {
            TextComponent.Builder builder;
            ComponentLike[] componentLikeArray = new ComponentLike[4];
            componentLikeArray[0] = SendersKt.emptyComponentOf();
            String $this$toComponent_u24default$iv = "Reload failed.";
            boolean $i$f$toComponent = false;
            String content$iv$iv = $this$toComponent_u24default$iv;
            boolean $i$f$componentOf = false;
            boolean $i$f$componentOf5 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            boolean bl = false;
            TextComponent.Builder builder9 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder9, (String)"content(...)");
            TextComponent.Builder bl4 = builder9;
            int n = 1;
            ComponentLike[] componentLikeArray3 = componentLikeArray;
            Audience audience = $audience;
            boolean bl5 = false;
            TextComponent.Builder builder10 = builder = bl4;
            BuildableComponent buildableComponent = builder10.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            componentLikeArray3[n] = (TextComponent)buildableComponent;
            $this$toComponent_u24default$iv = "Please read the log to find the problem.";
            $i$f$toComponent = false;
            content$iv$iv = $this$toComponent_u24default$iv;
            $i$f$componentOf = false;
            $i$f$componentOf5 = false;
            $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            bl = false;
            TextComponent.Builder builder11 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder11, (String)"content(...)");
            builder = builder11;
            n = 2;
            componentLikeArray3 = componentLikeArray;
            bl5 = false;
            builder10 = builder;
            BuildableComponent buildableComponent5 = builder10.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent5, (String)"build(...)");
            componentLikeArray3[n] = (TextComponent)buildableComponent5;
            componentLikeArray[3] = SendersKt.emptyComponentOf();
            SendersKt.warn(audience, componentLikeArray);
            SendersKt.warn($audience, new ComponentLike[0]);
            Throwable throwable = ((BetterModelPlugin.ReloadResult.Failure)result).throwable();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable(...)");
            PluginsKt.handleException(throwable, "Reload failed.");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void play$lambda$2(boolean $hide, EntityTracker it) {
        it.hideOption($hide ? EntityHideOption.DEFAULT : EntityHideOption.FALSE);
    }

    static {
        SuggestionProvider suggestionProvider = SuggestionProvider.blockingStrings(CommandManager::modelSuggestion$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)suggestionProvider, (String)"blockingStrings(...)");
        modelSuggestion = suggestionProvider;
        SuggestionProvider suggestionProvider2 = SuggestionProvider.blockingStrings(CommandManager::limbSuggestion$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)suggestionProvider2, (String)"blockingStrings(...)");
        limbSuggestion = suggestionProvider2;
    }
}

