/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.toxicity.model.api.bone.BoneName;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum BoneTag {
    NONE(new String[0]),
    HEAD(new String[]{"h"}),
    HEAD_WITH_CHILDREN(new String[]{"hi"}),
    HITBOX(new String[]{"b", "ob"}),
    SEAT(new String[]{"p"}),
    SUB_SEAT(new String[]{"sp"});

    public static final Pattern TAG_PATTERN;
    private static final Map<String, BoneTag> BY_NAME;
    private final String[] tag;

    @NotNull
    public static Optional<BoneTag> byTagName(@NotNull String tag) {
        return Optional.ofNullable(BY_NAME.get(tag));
    }

    @NotNull
    public static BoneName parse(@NotNull String rawName) {
        Matcher matcher = TAG_PATTERN.matcher(rawName);
        if (matcher.find()) {
            return BoneTag.byTagName(matcher.group("tag")).map(t -> new BoneName((BoneTag)((Object)t), matcher.group("name"))).orElseGet(() -> new BoneName(NONE, rawName));
        }
        return new BoneName(NONE, rawName);
    }

    @Generated
    public String[] getTag() {
        return this.tag;
    }

    @Generated
    private BoneTag(String[] tag) {
        this.tag = tag;
    }

    static {
        TAG_PATTERN = Pattern.compile("^(?<tag>[a-zA-Z]+)_(?<name>(\\w|\\W)+)$");
        BY_NAME = new HashMap<String, BoneTag>();
        for (BoneTag value : BoneTag.values()) {
            for (String s : value.tag) {
                BoneTag checkDuplicate = BY_NAME.put(s, value);
                if (checkDuplicate == null) continue;
                throw new RuntimeException("Duplicated tag: " + value.name() + " between " + checkDuplicate.name());
            }
        }
    }
}

