/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.NotNull;

public record BlueprintTexture(@NotNull String name, BufferedImage image, int uvWidth, int uvHeight) {
    @NotNull
    public static BlueprintTexture from(@NotNull ModelTexture blueprint) {
        BufferedImage image;
        try (ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(blueprint.source().split(",")[1]));
             BufferedInputStream buffered = new BufferedInputStream(input);){
            image = ImageIO.read(buffered);
        }
        catch (Exception e) {
            throw new RuntimeException("image");
        }
        return new BlueprintTexture(blueprint.name().split("\\.")[0], image, blueprint.uvWidth(), blueprint.uvHeight());
    }

    public boolean isAnimatedTexture() {
        if (this.uvWidth > 0 && this.uvHeight > 0) {
            float w;
            float h = (float)this.image.getHeight() / (float)this.uvHeight;
            return h > (w = (float)this.image.getWidth() / (float)this.uvWidth);
        }
        return this.image.getHeight() / this.image.getWidth() > 1;
    }

    @NotNull
    public JsonObject toMcmeta() {
        JsonObject json = new JsonObject();
        JsonObject animation = new JsonObject();
        animation.addProperty("interpolate", Boolean.valueOf(true));
        animation.addProperty("frametime", (Number)BetterModel.inst().configManager().animatedTextureFrameTime());
        json.add("animation", (JsonElement)animation);
        return json;
    }

    @NotNull
    public String packName(@NotNull String parentName) {
        return BetterModel.inst().configManager().namespace() + ":item/" + PackUtil.toPackName(parentName + "_" + this.name());
    }

    @NotNull
    public ModelResolution resolution() {
        return new ModelResolution(this.uvWidth, this.uvHeight);
    }
}

