/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Map;
import java.util.stream.Collectors;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTag;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.mount.MountController;
import kr.toxicity.model.api.mount.MountControllers;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RendererGroup {
    private final BoneName name;
    private final BlueprintChildren.BlueprintGroup parent;
    private final Vector3f position;
    private final Vector3f rotation;
    private final TransformedItemStack itemStack;
    private final @Unmodifiable Map<BoneName, RendererGroup> children;
    @Nullable
    private final NamedBoundingBox hitBox;
    private final Vector3f center;
    @Nullable
    private final PlayerLimb limb;
    @NotNull
    private final MountController mountController;

    public RendererGroup(@NotNull BoneName name, float scale, @Nullable ItemStack itemStack, @NotNull BlueprintChildren.BlueprintGroup group, @NotNull Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox box, @Nullable PlayerLimb limb) {
        this.name = name;
        this.limb = limb;
        this.parent = group;
        this.children = children;
        this.itemStack = new TransformedItemStack(new Vector3f(), new Vector3f(scale), itemStack != null ? itemStack : new ItemStack(Material.AIR));
        this.position = MathUtil.blockBenchToDisplay(group.origin().toVector().div(16.0f));
        this.hitBox = box;
        this.rotation = group.rotation().toVector();
        Vector3f vector3f = this.center = this.hitBox != null ? this.hitBox.centerPoint() : new Vector3f();
        this.mountController = name.tagged(BoneTag.SEAT) ? MountControllers.WALK : (name.tagged(BoneTag.SUB_SEAT) ? MountControllers.NONE : MountControllers.INVALID);
    }

    @NotNull
    public RenderedBone create(@Nullable Player player, @NotNull TrackerModifier modifier, @NotNull Location location) {
        return this.create(player, modifier, null, location);
    }

    @NotNull
    private RenderedBone create(@Nullable Player player, @NotNull TrackerModifier modifier, @Nullable RenderedBone entityParent, @NotNull Location location) {
        return new RenderedBone(this, entityParent, this.getItem(player), this.limb != null ? this.limb.getTransform() : ItemDisplay.ItemDisplayTransform.FIXED, location, new BoneMovement(entityParent != null ? new Vector3f((Vector3fc)this.position).sub((Vector3fc)entityParent.getGroup().position) : new Vector3f(), new Vector3f(1.0f), MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(this.rotation)), this.rotation), modifier, parent1 -> this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RendererGroup)e.getValue()).create(player, modifier, (RenderedBone)parent1, location))));
    }

    @NotNull
    private TransformedItemStack getItem(@Nullable Player player) {
        if (player != null) {
            return this.limb != null ? this.limb.createItem(player) : this.itemStack.asAir();
        }
        return this.itemStack;
    }

    @NotNull
    public TransformedItemStack getItemStack() {
        return this.itemStack.copy();
    }

    @Generated
    public RendererGroup(BoneName name, BlueprintChildren.BlueprintGroup parent, Vector3f position, Vector3f rotation, TransformedItemStack itemStack, Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox hitBox, Vector3f center, @Nullable PlayerLimb limb, @NotNull MountController mountController) {
        if (mountController == null) {
            throw new NullPointerException("mountController is marked non-null but is null");
        }
        this.name = name;
        this.parent = parent;
        this.position = position;
        this.rotation = rotation;
        this.itemStack = itemStack;
        this.children = children;
        this.hitBox = hitBox;
        this.center = center;
        this.limb = limb;
        this.mountController = mountController;
    }

    @Generated
    public BoneName getName() {
        return this.name;
    }

    @Generated
    public BlueprintChildren.BlueprintGroup getParent() {
        return this.parent;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Map<BoneName, RendererGroup> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public NamedBoundingBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public Vector3f getCenter() {
        return this.center;
    }

    @Nullable
    @Generated
    public PlayerLimb getLimb() {
        return this.limb;
    }

    @NotNull
    @Generated
    public MountController getMountController() {
        return this.mountController;
    }
}

