/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.Objects;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.RenderedBone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface BonePredicate
extends Predicate<RenderedBone> {
    public static final BonePredicate TRUE = BonePredicate.of(true, b -> true);
    public static final BonePredicate FALSE = BonePredicate.of(false, b -> false);

    public boolean applyAtChildren();

    @NotNull
    public static BonePredicate of(@NotNull Predicate<RenderedBone> predicate) {
        return BonePredicate.of(false, predicate);
    }

    @NotNull
    public static BonePredicate of(final boolean applyAtChildren, final @NotNull Predicate<RenderedBone> predicate) {
        Objects.requireNonNull(predicate);
        return new BonePredicate(){

            @Override
            public boolean applyAtChildren() {
                return applyAtChildren;
            }

            @Override
            public boolean test(RenderedBone renderedBone) {
                return predicate.test(renderedBone);
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    default public BonePredicate children(boolean parentSuccess) {
        return parentSuccess ? (this.applyAtChildren() ? TRUE : FALSE) : this;
    }
}

