/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.FloatFunction;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;

public record BlueprintAnimator(@NotNull String name, @NotNull @Unmodifiable List<AnimationMovement> keyFrame) {
    @NotNull
    public AnimationIterator<AnimationMovement> iterator(@NotNull AnimationIterator.Type type) {
        return type.create(this.keyFrame);
    }

    public static final class Builder {
        private final float length;
        private final List<VectorPoint> transform = new ArrayList<VectorPoint>();
        private final List<VectorPoint> scale = new ArrayList<VectorPoint>();
        private final List<VectorPoint> rotation = new ArrayList<VectorPoint>();

        public void addFrame(@NotNull ModelKeyframe keyframe, @NotNull ModelPlaceholder placeholder) {
            float time = keyframe.time();
            if (time > this.length) {
                return;
            }
            VectorInterpolator interpolation = keyframe.findInterpolator();
            FloatFunction<Vector3f> function = keyframe.point().toFunction(placeholder);
            switch (keyframe.channel()) {
                case POSITION: {
                    this.transform.add(new VectorPoint(function.map(vec -> MathUtil.transformToDisplay(vec).div(16.0f)).memoize(), time, interpolation));
                    break;
                }
                case ROTATION: {
                    this.rotation.add(new VectorPoint(function.map(MathUtil::animationToDisplay).memoize(), time, interpolation));
                    break;
                }
                case SCALE: {
                    this.scale.add(new VectorPoint(function.map(vec -> vec.sub(1.0f, 1.0f, 1.0f)).memoize(), time, interpolation));
                }
            }
        }

        @NotNull
        public AnimatorData build(@NotNull String name) {
            return new AnimatorData(name, this.transform, this.scale, this.rotation);
        }

        @Generated
        public Builder(float length) {
            this.length = length;
        }
    }

    public record AnimatorData(@NotNull String name, @NotNull List<VectorPoint> position, @NotNull List<VectorPoint> scale, @NotNull List<VectorPoint> rotation) {
        @NotNull
        public Stream<VectorPoint> allPoints() {
            return Stream.concat(Stream.concat(this.position.stream(), this.scale.stream()), this.rotation.stream());
        }
    }
}

