/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.util;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.pack.PackByte;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import kr.toxicity.model.api.pack.PackResult;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Lazy;
import kr.toxicity.model.shaded.kotlin.LazyKt;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.util.FolderGenerator;
import kr.toxicity.model.util.PackGenerator;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/model/util/FolderGenerator;", "Lkr/toxicity/model/util/PackGenerator;", "<init>", "()V", "file", "Ljava/io/File;", "exists", "", "getExists", "()Z", "fileTree", "Ljava/util/SortedMap;", "", "Ljava/nio/file/Path;", "getFileTree", "()Ljava/util/SortedMap;", "fileTree$delegate", "Lkr/toxicity/model/shaded/kotlin/Lazy;", "toFile", "Lkr/toxicity/model/api/pack/PackPath;", "create", "Lkr/toxicity/model/api/pack/PackResult;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "core"})
@SourceDebugExtension(value={"SMAP\nPacks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/FolderGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n*L\n1#1,137:1\n1869#2,2:138\n29#3,2:140\n*S KotlinDebug\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/FolderGenerator\n*L\n80#1:138,2\n74#1:140,2\n*E\n"})
public final class FolderGenerator
implements PackGenerator {
    @NotNull
    private final File file = new File(PluginsKt.getDATA_FOLDER().getParent(), PluginsKt.getCONFIG().buildFolderLocation());
    private final boolean exists = this.file.exists();
    @NotNull
    private final Lazy fileTree$delegate = LazyKt.lazy(() -> FolderGenerator.fileTree_delegate$lambda$0(this));

    @Override
    public boolean getExists() {
        return this.exists;
    }

    private final SortedMap<String, Path> getFileTree() {
        Lazy lazy = this.fileTree$delegate;
        return (SortedMap)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File toFile(PackPath $this$toFile) {
        File file;
        String string = $this$toFile.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        String replaced = StringsKt.replace$default((String)string, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        SortedMap<String, Path> sortedMap = this.getFileTree();
        synchronized (sortedMap) {
            boolean $i$a$-synchronized-FolderGenerator$toFile$22 = false;
            Path path = (Path)this.getFileTree().remove(replaced);
            File $i$a$-synchronized-FolderGenerator$toFile$22 = path != null ? path.toFile() : null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_3
            file = $i$a$-synchronized-FolderGenerator$toFile$22;
        }
        File file2 = file;
        if (file == null) {
            File file3;
            File $this$toFile_u24lambda_u241 = file3 = new File(this.file, replaced);
            boolean bl = false;
            $this$toFile_u24lambda_u241.getParentFile().mkdirs();
            file2 = file3;
        }
        return file2;
    }

    @Override
    @NotNull
    public PackResult create(@NotNull PackZipper zipper, @NotNull ReloadPipeline pipeline) {
        PackResult packResult;
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        PackZipper.BuildData buildData = zipper.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildData, (String)"build(...)");
        PackZipper.BuildData build = buildData;
        PackResult pack = new PackResult(build.meta(), this.file);
        AtomicBoolean changed = new AtomicBoolean();
        List<PackResource> list = build.resources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"resources(...)");
        pipeline.forEachParallel(list, create.1.INSTANCE, arg_0 -> FolderGenerator.create$lambda$0(pack, this, changed, pipeline, arg_0));
        Collection<Path> collection = this.getFileTree().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            it.toFile().delete();
        }
        PackResult $this$create_u24lambda_u242 = packResult = pack;
        boolean bl = false;
        $this$create_u24lambda_u242.freeze(changed.get());
        return packResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SortedMap fileTree_delegate$lambda$0(FolderGenerator this$0) {
        SortedMap sortedMap;
        Comparator comparator = Comparator.reverseOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reverseOrder(...)");
        SortedMap $this$fileTree_delegate_u24lambda_u240_u240 = sortedMap = MapsKt.sortedMapOf(comparator, (Pair[])new Pair[0]);
        boolean bl = false;
        String after = PluginsKt.getCONFIG().buildFolderLocation() + File.separatorChar;
        Object object = this$0.file;
        File $this$fileTree_delegate_u24lambda_u240_u240_u240 = object;
        boolean bl2 = false;
        $this$fileTree_delegate_u24lambda_u240_u240_u240.mkdirs();
        object = Files.walk(((File)object).toPath(), new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl3 = false;
            stream.forEach(arg_0 -> FolderGenerator.fileTree_delegate$lambda$0$0$1$1(arg_0 -> FolderGenerator.fileTree_delegate$lambda$0$0$1$0($this$fileTree_delegate_u24lambda_u240_u240, after, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        return sortedMap;
    }

    private static final Unit fileTree_delegate$lambda$0$0$1$0(SortedMap $this_apply, String $after, Path it) {
        Intrinsics.checkNotNull((Object)it);
        $this_apply.put(StringsKt.substringAfter$default((String)((Object)it).toString(), (String)$after, null, (int)2, null), it);
        return Unit.INSTANCE;
    }

    private static final void fileTree_delegate$lambda$0$0$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit create$lambda$0(PackResult $pack, FolderGenerator this$0, AtomicBoolean $changed, ReloadPipeline $pipeline, PackResource it) {
        byte[] bytes = (byte[])it.get();
        $pack.set(it.overlay(), new PackByte(it.path(), bytes));
        PackPath packPath = it.path();
        Intrinsics.checkNotNullExpressionValue((Object)packPath, (String)"path(...)");
        File file = this$0.toFile(packPath);
        if (file.length() != (long)bytes.length) {
            Intrinsics.checkNotNull((Object)bytes);
            FilesKt.writeBytes((File)file, (byte[])bytes);
            $changed.set(true);
            boolean $i$f$debugPack = false;
            if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
                String[] stringArray = new String[1];
                String string = Thread.currentThread().getName();
                int n = 0;
                String[] stringArray2 = stringArray;
                boolean bl = false;
                String string2 = "This file was successfully generated: " + it.path();
                stringArray2[n] = "[" + string + "] " + string2;
                PluginsKt.info(stringArray);
            }
        }
        $pipeline.progress();
        return Unit.INSTANCE;
    }
}

