/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.tracker.Tracker;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnimationStateHandler<T extends Timed> {
    private final T initialValue;
    private final AnimationMapper<T> mapper;
    private final Consumer<T> setConsumer;
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private final AtomicBoolean forceUpdateAnimation = new AtomicBoolean();
    private int delay;
    private volatile TreeIterator currentIterator = null;
    private volatile T keyframe = null;

    public boolean keyframeFinished() {
        return this.delay <= 0;
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        TreeIterator iterator2 = this.currentIterator;
        return iterator2 != null ? iterator2.animation : null;
    }

    public boolean tick() {
        --this.delay;
        return this.shouldUpdateAnimation() && this.updateAnimation();
    }

    private boolean shouldUpdateAnimation() {
        return this.forceUpdateAnimation.compareAndSet(true, false) || this.keyframeFinished() || this.delay % Tracker.MINECRAFT_TICK_MULTIPLIER == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.reversedView.iterator();
            while (iterator2.hasNext()) {
                TreeIterator next = iterator2.next();
                if (!next.getAsBoolean()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator = next;
                    return true;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0;
                    return true;
                }
                if (this.keyframeFinished()) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    return true;
                }
                return false;
            }
        }
        return this.setKeyframe(null);
    }

    private boolean updateKeyframe(@NotNull Iterator<TreeIterator> iterator2, @NotNull TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        return this.setKeyframe(next.next());
    }

    private boolean setKeyframe(@Nullable T next) {
        if (this.keyframe == next) {
            return false;
        }
        this.keyframe = next;
        this.setConsumer.accept(this.keyframe);
        this.delay = Math.round(this.frame());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimation(@NotNull String name, @NotNull AnimationIterator<T> iterator2, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            this.animators.putLast(name, new TreeIterator(name, iterator2, modifier, removeTask));
        }
        this.forceUpdateAnimation.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAnimation(@NotNull String name, @NotNull AnimationIterator<T> iterator2, @NotNull AnimationModifier modifier) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            TreeIterator v = (TreeIterator)this.animators.get(name);
            if (v != null) {
                this.animators.replace(name, new TreeIterator(name, iterator2, v.modifier, v.removeTask));
            } else {
                this.animators.replace(name, new TreeIterator(name, iterator2, modifier, () -> {}));
            }
        }
        this.forceUpdateAnimation.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull String name) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            if (this.animators.remove(name) != null) {
                this.forceUpdateAnimation.set(true);
            }
        }
    }

    public float frame() {
        return this.keyframe != null ? this.keyframe.time() * 20.0f * (float)Tracker.MINECRAFT_TICK_MULTIPLIER : 0.0f;
    }

    @Generated
    public AnimationStateHandler(T initialValue, AnimationMapper<T> mapper, Consumer<T> setConsumer) {
        this.initialValue = initialValue;
        this.mapper = mapper;
        this.setConsumer = setConsumer;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Generated
    public T getKeyframe() {
        return this.keyframe;
    }

    private class TreeIterator
    implements BooleanSupplier,
    Runnable {
        private final RunningAnimation animation;
        private final AnimationIterator<T> iterator;
        private final AnimationModifier modifier;
        private final Runnable removeTask;
        private final T previous;
        private boolean started = false;
        private boolean ended = false;

        public TreeIterator(String name, AnimationIterator<T> iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.animation = new RunningAnimation(name, iterator2.type());
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
            this.previous = AnimationStateHandler.this.keyframe != null ? AnimationStateHandler.this.keyframe : AnimationStateHandler.this.initialValue;
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public boolean getAsBoolean() {
            return this.modifier.predicate().getAsBoolean();
        }

        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        @NotNull
        public T next() {
            if (!this.started) {
                this.started = true;
                return AnimationStateHandler.this.mapper.map((Timed)this.iterator.next(), MappingState.START, (float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return AnimationStateHandler.this.mapper.map(this.previous, MappingState.END, (float)this.modifier.end() / 20.0f);
            }
            Timed nxt = (Timed)this.iterator.next();
            return AnimationStateHandler.this.mapper.map(nxt, MappingState.PROGRESS, nxt.time() / this.modifier.speedValue());
        }

        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }
    }

    @FunctionalInterface
    public static interface AnimationMapper<T extends Timed> {
        @NotNull
        public T map(T var1, @NotNull MappingState var2, float var3);
    }

    public static enum MappingState {
        START,
        PROGRESS,
        END;

    }

    @FunctionalInterface
    public static interface AnimationCreator<T extends Timed> {
        @NotNull
        public T create(float var1);
    }
}

