/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolator;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@ApiStatus.Internal
public enum CatmullRomInterpolator implements VectorInterpolator
{
    INSTANCE;


    @NotNull
    private static VectorPoint indexOf(@NotNull List<VectorPoint> list, int index, int relative) {
        int i;
        for (i = index + relative; i < 0; i += list.size()) {
        }
        return list.get(i % list.size());
    }

    @Override
    @NotNull
    public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
        VectorPoint p0 = CatmullRomInterpolator.indexOf(points, p2Index, -2);
        VectorPoint p1 = CatmullRomInterpolator.indexOf(points, p2Index, -1);
        VectorPoint p2 = points.get(p2Index);
        VectorPoint p3 = CatmullRomInterpolator.indexOf(points, p2Index, 1);
        float t1 = p1.time();
        float t2 = p2.time();
        float a = InterpolationUtil.alpha(t1, t2, time);
        return InterpolationUtil.catmull_rom(p0.vector(), p1.vector(InterpolationUtil.lerp(t1, t2, a)), p2.vector(), p3.vector(), a);
    }
}

