/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final JsonDeserializer<ModelChildren> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new ModelUUID(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonArray children = json.getAsJsonObject().getAsJsonArray("children");
            return new ModelOutliner((ModelGroup)context.deserialize(json, ModelGroup.class), children.asList().stream().map(child -> (ModelChildren)context.deserialize(child, ModelChildren.class)).toList());
        }
        throw new RuntimeException();
    };

    @NotNull
    public BlueprintChildren toBlueprint(@NotNull ModelLoadContext var1);

    @NotNull
    public Stream<ModelChildren> flatten();

    @NotNull
    public String uuid();

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintChildren toBlueprint(@NotNull ModelLoadContext context) {
            return new BlueprintChildren.BlueprintElement(Objects.requireNonNull(context.elements.get(this.uuid())));
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.of(this);
        }
    }

    public record ModelOutliner(@NotNull ModelGroup group, @NotNull @Unmodifiable List<ModelChildren> children) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintChildren toBlueprint(@NotNull ModelLoadContext context) {
            List<BlueprintChildren> child = CollectionUtil.mapToList(this.children, c2 -> c2.toBlueprint(context));
            List<BlueprintChildren.BlueprintElement> filtered = CollectionUtil.filterIsInstance(child, BlueprintChildren.BlueprintElement.class).toList();
            ModelGroup selectedGroup = context.groups.getOrDefault(this.uuid(), this.group);
            return new BlueprintChildren.BlueprintGroup(BoneTagRegistry.parse(selectedGroup.name()), selectedGroup.origin(), selectedGroup.rotation().invertXZ(), child, filtered.isEmpty() ? selectedGroup.visibility() : filtered.stream().anyMatch(element -> element.element().visibility()));
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(ModelChildren::flatten));
        }

        @Override
        @NotNull
        public String uuid() {
            return this.group.uuid();
        }
    }
}

