/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolator;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@ApiStatus.Internal
public enum LinearInterpolator implements VectorInterpolator
{
    INSTANCE;


    @Override
    @NotNull
    public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
        VectorPoint p1 = p2Index > 0 ? points.get(p2Index - 1) : points.getFirst();
        VectorPoint p2 = points.get(p2Index);
        float t1 = p1.time();
        float t2 = p2.time();
        float a2 = InterpolationUtil.alpha(t1, t2, time);
        return InterpolationUtil.lerp(p1.vector(InterpolationUtil.lerp(t1, t2, a2)), p2.vector(), a2);
    }

    public String toString() {
        return "linear";
    }
}

