/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import kr.toxicity.model.BetterModelPluginImpl;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.manager.CommandManager;
import kr.toxicity.model.api.manager.CompatibilityManager;
import kr.toxicity.model.api.manager.ConfigManager;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.scheduler.ModelScheduler;
import kr.toxicity.model.api.version.MinecraftVersion;
import kr.toxicity.model.manager.CommandManagerImpl;
import kr.toxicity.model.manager.CompatibilityManagerImpl;
import kr.toxicity.model.manager.ConfigManagerImpl;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.manager.ModelManagerImpl;
import kr.toxicity.model.manager.PlayerManagerImpl;
import kr.toxicity.model.manager.ScriptManagerImpl;
import kr.toxicity.model.nms.v1_21_R2.NMSImpl;
import kr.toxicity.model.scheduler.PaperScheduler;
import kr.toxicity.model.scheduler.StandardScheduler;
import kr.toxicity.model.shaded.kotlin.Lazy;
import kr.toxicity.model.shaded.kotlin.LazyKt;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.util.ListsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0015\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J(\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001a0'J\b\u0010)\u001a\u00020*H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;H\u0016J\u0016\u0010<\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0=H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\u001d0\u0018j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\u001d`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lkr/toxicity/model/BetterModelPluginImpl;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lkr/toxicity/model/api/BetterModelPlugin;", "<init>", "()V", "version", "Lkr/toxicity/model/api/version/MinecraftVersion;", "nms", "Lkr/toxicity/model/api/nms/NMS;", "onReload", "Ljava/util/concurrent/atomic/AtomicBoolean;", "managers", "", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "getManagers", "()Ljava/util/List;", "managers$delegate", "Lkr/toxicity/model/shaded/kotlin/Lazy;", "scheduler", "Lkr/toxicity/model/api/scheduler/ModelScheduler;", "log", "kr/toxicity/model/BetterModelPluginImpl$log$1", "Lkr/toxicity/model/BetterModelPluginImpl$log$1;", "reloadStartTask", "Ljava/util/ArrayList;", "Lkr/toxicity/model/shaded/kotlin/Function0;", "", "Lkr/toxicity/model/shaded/kotlin/collections/ArrayList;", "reloadEndTask", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/BetterModelPlugin$ReloadResult;", "onLoad", "onEnable", "onDisable", "reload", "loadAssets", "prefix", "", "consumer", "Lkr/toxicity/model/shaded/kotlin/Function2;", "Ljava/io/InputStream;", "logger", "Lkr/toxicity/model/api/BetterModelLogger;", "modelManager", "Lkr/toxicity/model/api/manager/ModelManager;", "playerManager", "Lkr/toxicity/model/api/manager/PlayerManager;", "entityManager", "Lkr/toxicity/model/api/manager/EntityManager;", "commandManager", "Lkr/toxicity/model/api/manager/CommandManager;", "compatibilityManager", "Lkr/toxicity/model/api/manager/CompatibilityManager;", "configManager", "Lkr/toxicity/model/api/manager/ConfigManager;", "scriptManager", "Lkr/toxicity/model/api/manager/ScriptManager;", "addReloadStartHandler", "runnable", "Ljava/lang/Runnable;", "addReloadEndHandler", "Ljava/util/function/Consumer;", "core"})
@SourceDebugExtension(value={"SMAP\nBetterModelPluginImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetterModelPluginImpl.kt\nkr/toxicity/model/BetterModelPluginImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1869#2,2:169\n1869#2,2:171\n1869#2,2:173\n1869#2,2:175\n1869#2,2:177\n*S KotlinDebug\n*F\n+ 1 BetterModelPluginImpl.kt\nkr/toxicity/model/BetterModelPluginImpl\n*L\n91#1:169,2\n108#1:171,2\n114#1:173,2\n119#1:175,2\n125#1:177,2\n*E\n"})
public final class BetterModelPluginImpl
extends JavaPlugin
implements BetterModelPlugin {
    @NotNull
    private final MinecraftVersion version;
    private NMS nms;
    @NotNull
    private final AtomicBoolean onReload;
    @NotNull
    private final Lazy managers$delegate;
    @NotNull
    private final ModelScheduler scheduler;
    @NotNull
    private final log.1 log;
    @NotNull
    private final ArrayList<Function0<Unit>> reloadStartTask;
    @NotNull
    private final ArrayList<Function1<BetterModelPlugin.ReloadResult, Unit>> reloadEndTask;

    public BetterModelPluginImpl() {
        String string = Bukkit.getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        this.version = new MinecraftVersion(StringsKt.substringBefore$default(string, '-', null, 2, null));
        this.onReload = new AtomicBoolean();
        this.managers$delegate = LazyKt.lazy(BetterModelPluginImpl::managers_delegate$lambda$0);
        this.scheduler = BetterModel.IS_PAPER ? (ModelScheduler)new PaperScheduler() : (ModelScheduler)new StandardScheduler();
        this.log = new BetterModelLogger(this){
            final /* synthetic */ BetterModelPluginImpl this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void info(String ... message) {
                Logger logger;
                Intrinsics.checkNotNullParameter(message, "message");
                Logger logger2 = this.this$0.getLogger();
                Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(...)");
                Logger logger3 = logger = logger2;
                synchronized (logger3) {
                    boolean bl = false;
                    for (String s : message) {
                        logger.info(s);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void warn(String ... message) {
                Logger logger;
                Intrinsics.checkNotNullParameter(message, "message");
                Logger logger2 = this.this$0.getLogger();
                Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(...)");
                Logger logger3 = logger = logger2;
                synchronized (logger3) {
                    boolean bl = false;
                    for (String s : message) {
                        logger.warning(s);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this.reloadStartTask = new ArrayList();
        this.reloadEndTask = new ArrayList();
    }

    private final List<GlobalManagerImpl> getManagers() {
        Lazy lazy = this.managers$delegate;
        return (List)lazy.getValue();
    }

    public void onLoad() {
        BetterModel.inst(this);
    }

    public void onEnable() {
        NMS nMS;
        MinecraftVersion minecraftVersion = this.version;
        if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_5)) {
            nMS = new kr.toxicity.model.nms.v1_21_R4.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_4)) {
            nMS = new kr.toxicity.model.nms.v1_21_R3.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_2) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_3)) {
            nMS = new NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_1)) {
            nMS = new kr.toxicity.model.nms.v1_21_R1.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_5) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_6)) {
            nMS = new kr.toxicity.model.nms.v1_20_R4.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_3) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_4)) {
            nMS = new kr.toxicity.model.nms.v1_20_R3.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_2)) {
            nMS = new kr.toxicity.model.nms.v1_20_R2.NMSImpl();
        } else {
            String[] stringArray = new String[]{"Unsupported version: " + this.version, "Plugin will be automatically disabled."};
            PluginsKt.warn(stringArray);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.nms = nMS;
        Iterable $this$forEach$iv = this.getManagers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalManagerImpl p0 = (GlobalManagerImpl)element$iv;
            boolean bl = false;
            p0.start();
        }
        BetterModelPlugin.ReloadResult result = this.reload();
        if (result instanceof BetterModelPlugin.ReloadResult.Failure) {
            Throwable throwable = ((BetterModelPlugin.ReloadResult.Failure)result).throwable();
            Intrinsics.checkNotNullExpressionValue(throwable, "throwable(...)");
            PluginsKt.handleException(throwable, "Unable to load plugin properly.");
        } else {
            if (result instanceof BetterModelPlugin.ReloadResult.OnReload) {
                throw new RuntimeException("Plugin load failed.");
            }
            if (result instanceof BetterModelPlugin.ReloadResult.Success) {
                String[] stringArray = new String[3];
                stringArray[0] = "Plugin is loaded. (" + ((BetterModelPlugin.ReloadResult.Success)result).time() + " ms)";
                NMS nMS2 = this.nms;
                if (nMS2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("nms");
                    nMS2 = null;
                }
                stringArray[1] = "Minecraft version: " + this.version + ", NMS version: " + nMS2.version();
                stringArray[2] = "Platform: " + (BetterModel.IS_PURPUR ? "Purpur" : (BetterModel.IS_PAPER ? "Paper" : "Bukkit"));
                PluginsKt.info(stringArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void onDisable() {
        Iterable $this$forEach$iv = this.getManagers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalManagerImpl p0 = (GlobalManagerImpl)element$iv;
            boolean bl = false;
            p0.end();
        }
    }

    @Override
    @NotNull
    public BetterModelPlugin.ReloadResult reload() {
        Object object;
        Object $this$reload_u24lambda_u244;
        if (this.onReload.get()) {
            return new BetterModelPlugin.ReloadResult.OnReload();
        }
        this.onReload.set(true);
        Iterable $this$forEach$iv = this.reloadStartTask;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
        Object $i$f$forEach22 = this;
        try {
            $this$reload_u24lambda_u244 = $i$f$forEach22;
            boolean bl = false;
            long time = System.currentTimeMillis();
            Iterable $this$forEach$iv2 = super.getManagers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                GlobalManagerImpl p0 = (GlobalManagerImpl)element$iv;
                boolean bl2 = false;
                p0.reload();
            }
            $this$reload_u24lambda_u244 = Result.constructor-impl(new BetterModelPlugin.ReloadResult.Success(System.currentTimeMillis() - time));
        }
        catch (Throwable bl) {
            $this$reload_u24lambda_u244 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        $i$f$forEach22 = $this$reload_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl($i$f$forEach22);
        if (throwable == null) {
            object = $i$f$forEach22;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = new BetterModelPlugin.ReloadResult.Failure(it);
        }
        Object result = object;
        this.onReload.set(false);
        Iterable $this$forEach$iv3 = this.reloadEndTask;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(result);
        }
        return (BetterModelPlugin.ReloadResult)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAssets(@NotNull String prefix, @NotNull Function2<? super String, ? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        Closeable closeable = new JarFile(this.getFile());
        Throwable throwable = null;
        try {
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = it.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            ArrayList<JarEntry> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
            ListsKt.forEachAsync((List)arrayList, arg_0 -> BetterModelPluginImpl.loadAssets$lambda$9$lambda$8(prefix, it, consumer, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    @NotNull
    public BetterModelLogger logger() {
        return this.log;
    }

    @Override
    @NotNull
    public ModelScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public ModelManager modelManager() {
        return ModelManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public PlayerManager playerManager() {
        return PlayerManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public EntityManager entityManager() {
        return EntityManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public CommandManager commandManager() {
        return CommandManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public CompatibilityManager compatibilityManager() {
        return CompatibilityManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public ConfigManager configManager() {
        return ConfigManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public ScriptManager scriptManager() {
        return ScriptManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public MinecraftVersion version() {
        return this.version;
    }

    @Override
    @NotNull
    public NMS nms() {
        NMS nMS = this.nms;
        if (nMS == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nms");
            nMS = null;
        }
        return nMS;
    }

    @Override
    public void addReloadStartHandler(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        ((Collection)this.reloadStartTask).add(() -> BetterModelPluginImpl.addReloadStartHandler$lambda$10(runnable));
    }

    @Override
    public void addReloadEndHandler(@NotNull Consumer<BetterModelPlugin.ReloadResult> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        ((Collection)this.reloadEndTask).add(arg_0 -> BetterModelPluginImpl.addReloadEndHandler$lambda$11(consumer, arg_0));
    }

    private static final List managers_delegate$lambda$0() {
        GlobalManagerImpl[] globalManagerImplArray = new GlobalManagerImpl[]{CompatibilityManagerImpl.INSTANCE, ConfigManagerImpl.INSTANCE, ModelManagerImpl.INSTANCE, PlayerManagerImpl.INSTANCE, EntityManagerImpl.INSTANCE, ScriptManagerImpl.INSTANCE, CommandManagerImpl.INSTANCE};
        return CollectionsKt.listOf(globalManagerImplArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit loadAssets$lambda$9$lambda$8(String $prefix, JarFile $it, Function2 $consumer, JarEntry entry) {
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (!StringsKt.startsWith$default(string, $prefix, false, 2, null)) {
            return Unit.INSTANCE;
        }
        if (entry.getName().length() <= $prefix.length() + 1) {
            return Unit.INSTANCE;
        }
        String string2 = entry.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        Object object = string2;
        int n = $prefix.length() + 1;
        String string3 = ((String)object).substring(n);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        String name = string3;
        if (!entry.isDirectory()) {
            InputStream inputStream = $it.getInputStream(entry);
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            object = inputStream;
            n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Throwable throwable = null;
            try {
                BufferedInputStream stream = (BufferedInputStream)object;
                boolean bl = false;
                $consumer.invoke(name, stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit addReloadStartHandler$lambda$10(Runnable $runnable) {
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final Unit addReloadEndHandler$lambda$11(Consumer $consumer, BetterModelPlugin.ReloadResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $consumer.accept(it);
        return Unit.INSTANCE;
    }
}

