/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import org.jetbrains.annotations.NotNull;

public record TrackerModifier(float scale, boolean sightTrace, boolean damageEffect, float viewRange, boolean shadow) {
    public static final TrackerModifier DEFAULT = new TrackerModifier(1.0f, true, true, 0.0f, true);

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float scale;
        private boolean sightTrace;
        private boolean damageEffect;
        private float viewRange;
        private boolean shadow;

        private Builder() {
            this.scale = TrackerModifier.DEFAULT.scale;
            this.sightTrace = TrackerModifier.DEFAULT.sightTrace;
            this.damageEffect = TrackerModifier.DEFAULT.damageEffect;
            this.viewRange = TrackerModifier.DEFAULT.viewRange;
            this.shadow = TrackerModifier.DEFAULT.shadow;
        }

        @NotNull
        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        @NotNull
        public Builder sightTrace(boolean sightTrace) {
            this.sightTrace = sightTrace;
            return this;
        }

        @NotNull
        public Builder damageEffect(boolean damageEffect) {
            this.damageEffect = damageEffect;
            return this;
        }

        @NotNull
        public Builder viewRange(float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        @NotNull
        public Builder shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        @NotNull
        public TrackerModifier build() {
            return new TrackerModifier(this.scale, this.sightTrace, this.damageEffect, this.viewRange, this.shadow);
        }
    }
}

