/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.armor.PlayerArmor;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.nms.Profiled;
import kr.toxicity.model.api.player.PlayerSkinParts;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.PlayerTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.Location;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface RenderSource<T extends Tracker> {
    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull Location location) {
        return new BaseDummy(location);
    }

    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull Location location, @NotNull GameProfile profile, boolean slim) {
        return new ProfiledDummy(location, profile, slim);
    }

    @ApiStatus.Internal
    @NotNull
    public static Entity of(@NotNull kr.toxicity.model.api.entity.BaseEntity entity, @NotNull GameProfile profile, boolean slim) {
        Record record;
        if (entity instanceof kr.toxicity.model.api.entity.BasePlayer) {
            kr.toxicity.model.api.entity.BasePlayer player = (kr.toxicity.model.api.entity.BasePlayer)entity;
            record = new ProfiledPlayer(player, profile, slim);
        } else {
            record = new ProfiledEntity(entity, profile, slim);
        }
        return record;
    }

    @ApiStatus.Internal
    @NotNull
    public static Entity of(@NotNull kr.toxicity.model.api.entity.BaseEntity entity) {
        Record record;
        if (entity instanceof kr.toxicity.model.api.entity.BasePlayer) {
            kr.toxicity.model.api.entity.BasePlayer player = (kr.toxicity.model.api.entity.BasePlayer)entity;
            record = new BasePlayer(player);
        } else {
            record = new BaseEntity(entity);
        }
        return record;
    }

    @NotNull
    public Location location();

    public T create(@NotNull RenderPipeline var1, @NotNull TrackerModifier var2, @NotNull Consumer<T> var3);

    public record BaseDummy(@NotNull Location location) implements Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }
    }

    public record ProfiledDummy(@NotNull Location location, @NotNull GameProfile profile, boolean isSlim) implements Profiled,
    Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return PlayerArmor.EMPTY;
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return PlayerSkinParts.DEFAULT;
        }
    }

    public static final class ProfiledPlayer
    extends Record
    implements Entity,
    Profiled {
        @NotNull
        private final kr.toxicity.model.api.entity.BasePlayer entity;
        @NotNull
        private final GameProfile profile;
        private final boolean isSlim;

        public ProfiledPlayer(@NotNull kr.toxicity.model.api.entity.BasePlayer entity, @NotNull GameProfile profile, boolean isSlim) {
            this.entity = entity;
            this.profile = profile;
            this.isSlim = isSlim;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new PlayerTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new PlayerTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return this.entity.armors();
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return this.entity.skinParts();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProfiledPlayer.class, "entity;profile;isSlim", "entity", "profile", "isSlim"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProfiledPlayer.class, "entity;profile;isSlim", "entity", "profile", "isSlim"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProfiledPlayer.class, "entity;profile;isSlim", "entity", "profile", "isSlim"}, this, o);
        }

        @Override
        @NotNull
        public kr.toxicity.model.api.entity.BasePlayer entity() {
            return this.entity;
        }

        @Override
        @NotNull
        public GameProfile profile() {
            return this.profile;
        }

        @Override
        public boolean isSlim() {
            return this.isSlim;
        }
    }

    public record ProfiledEntity(@NotNull kr.toxicity.model.api.entity.BaseEntity entity, @NotNull GameProfile profile, boolean isSlim) implements Entity,
    Profiled
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new EntityTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new EntityTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return PlayerArmor.EMPTY;
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return PlayerSkinParts.DEFAULT;
        }
    }

    public static final class BasePlayer
    extends Record
    implements Entity,
    Profiled {
        @NotNull
        private final kr.toxicity.model.api.entity.BasePlayer entity;

        public BasePlayer(@NotNull kr.toxicity.model.api.entity.BasePlayer entity) {
            this.entity = entity;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new PlayerTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new PlayerTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public GameProfile profile() {
            return this.entity.profile();
        }

        @Override
        public boolean isSlim() {
            PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(this.entity.uuid());
            return channel != null && channel.isSlim();
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return this.entity.armors();
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return this.entity.skinParts();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this, o);
        }

        @Override
        @NotNull
        public kr.toxicity.model.api.entity.BasePlayer entity() {
            return this.entity;
        }
    }

    public record BaseEntity(@NotNull kr.toxicity.model.api.entity.BaseEntity entity) implements Entity
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new EntityTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new EntityTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.location();
        }
    }

    public static sealed interface Dummy
    extends RenderSource<DummyTracker>
    permits BaseDummy, ProfiledDummy {
    }

    public static sealed interface Entity
    extends RenderSource<EntityTracker>
    permits BaseEntity, ProfiledEntity, BasePlayer, ProfiledPlayer {
        @NotNull
        public kr.toxicity.model.api.entity.BaseEntity entity();

        @NotNull
        public EntityTracker getOrCreate(@NotNull String var1, @NotNull Supplier<RenderPipeline> var2, @NotNull TrackerModifier var3, @NotNull Consumer<EntityTracker> var4);
    }
}

