/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model;

import com.vdurmont.semver4j.Semver;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import kr.toxicity.model.BetterModelConfigImpl;
import kr.toxicity.model.BetterModelEvaluatorImpl;
import kr.toxicity.model.BetterModelLibrary;
import kr.toxicity.model.BetterModelPluginImpl;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelEvaluator;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.config.IndicatorConfig;
import kr.toxicity.model.api.manager.CommandManager;
import kr.toxicity.model.api.manager.CompatibilityManager;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.manager.SkinManager;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.pack.PackResult;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.scheduler.ModelScheduler;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.util.HttpUtil;
import kr.toxicity.model.api.version.MinecraftVersion;
import kr.toxicity.model.configuration.PluginConfiguration;
import kr.toxicity.model.manager.CommandManagerImpl;
import kr.toxicity.model.manager.CompatibilityManagerImpl;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ModelManagerImpl;
import kr.toxicity.model.manager.PlayerManagerImpl;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.manager.ScriptManagerImpl;
import kr.toxicity.model.manager.SkinManagerImpl;
import kr.toxicity.model.nms.v1_21_R2.NMSImpl;
import kr.toxicity.model.scheduler.BukkitScheduler;
import kr.toxicity.model.scheduler.PaperScheduler;
import kr.toxicity.model.shaded.kotlin.Lazy;
import kr.toxicity.model.shaded.kotlin.LazyKt;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.shaded.org.bstats.bukkit.Metrics;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.FunctionsKt;
import kr.toxicity.model.util.IndicatorsKt;
import kr.toxicity.model.util.PackGenerator;
import kr.toxicity.model.util.PacksKt;
import kr.toxicity.model.util.PluginsKt;
import kr.toxicity.model.util.SendersKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u001a\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u00109\u001a\u000206H\u0016J\b\u0010:\u001a\u000206H\u0016J\b\u0010;\u001a\u000206H\u0016J\u0010\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0016J0\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002060EJ\b\u0010G\u001a\u00020HH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u00020WH\u0016J\b\u0010.\u001a\u00020XH\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010Y\u001a\u00020ZH\u0016J\u0016\u0010[\u001a\u0002062\f\u0010D\u001a\b\u0012\u0004\u0012\u0002050\\H\u0016J\u0016\u0010]\u001a\u0002062\f\u0010D\u001a\b\u0012\u0004\u0012\u0002080\\H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0004R\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0011\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0011\u001a\u0004\b&\u0010'R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u00020,2\u0006\u0010-\u001a\u00020,8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020604X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020604X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lkr/toxicity/model/BetterModelPluginImpl;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lkr/toxicity/model/api/BetterModelPlugin;", "<init>", "()V", "version", "Lkr/toxicity/model/api/version/MinecraftVersion;", "nms", "Lkr/toxicity/model/api/nms/NMS;", "onReload", "Ljava/util/concurrent/atomic/AtomicBoolean;", "managers", "", "Lkr/toxicity/model/manager/GlobalManager;", "getManagers", "()Ljava/util/List;", "managers$delegate", "Lkr/toxicity/model/shaded/kotlin/Lazy;", "scheduler", "Lkr/toxicity/model/api/scheduler/ModelScheduler;", "evaluator", "Lkr/toxicity/model/BetterModelEvaluatorImpl;", "getEvaluator", "()Lkr/toxicity/model/BetterModelEvaluatorImpl;", "evaluator$delegate", "log", "kr/toxicity/model/BetterModelPluginImpl$log$1", "Lkr/toxicity/model/BetterModelPluginImpl$log$1;", "semver", "Lcom/vdurmont/semver4j/Semver;", "getSemver$annotations", "attributes", "Ljava/util/jar/Attributes;", "getAttributes", "()Ljava/util/jar/Attributes;", "attributes$delegate", "snapshot", "", "getSnapshot", "()I", "snapshot$delegate", "_metrics", "Lkr/toxicity/model/shaded/org/bstats/bukkit/Metrics;", "_config", "Lkr/toxicity/model/BetterModelConfigImpl;", "value", "config", "getConfig", "()Lkr/toxicity/model/BetterModelConfigImpl;", "setConfig", "(Lkr/toxicity/model/BetterModelConfigImpl;)V", "reloadStartTask", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/pack/PackZipper;", "", "reloadEndTask", "Lkr/toxicity/model/api/BetterModelPlugin$ReloadResult;", "onLoad", "onEnable", "onDisable", "reload", "info", "Lkr/toxicity/model/api/manager/ReloadInfo;", "loadAssets", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "prefix", "", "consumer", "Lkr/toxicity/model/shaded/kotlin/Function2;", "Ljava/io/InputStream;", "logger", "Lkr/toxicity/model/api/BetterModelLogger;", "Lkr/toxicity/model/api/BetterModelEvaluator;", "modelManager", "Lkr/toxicity/model/api/manager/ModelManager;", "playerManager", "Lkr/toxicity/model/api/manager/PlayerManager;", "entityManager", "Lkr/toxicity/model/api/manager/EntityManager;", "commandManager", "Lkr/toxicity/model/api/manager/CommandManager;", "compatibilityManager", "Lkr/toxicity/model/api/manager/CompatibilityManager;", "scriptManager", "Lkr/toxicity/model/api/manager/ScriptManager;", "skinManager", "Lkr/toxicity/model/api/manager/SkinManager;", "Lkr/toxicity/model/api/BetterModelConfig;", "isSnapshot", "", "addReloadStartHandler", "Ljava/util/function/Consumer;", "addReloadEndHandler", "core"})
@SourceDebugExtension(value={"SMAP\nBetterModelPluginImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetterModelPluginImpl.kt\nkr/toxicity/model/BetterModelPluginImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Senders.kt\nkr/toxicity/model/util/SendersKt\n*L\n1#1,270:1\n1869#2,2:271\n1869#2,2:281\n1869#2,2:283\n1869#2,2:285\n39#3,4:273\n39#3,4:277\n*S KotlinDebug\n*F\n+ 1 BetterModelPluginImpl.kt\nkr/toxicity/model/BetterModelPluginImpl\n*L\n137#1:271,2\n182#1:281,2\n184#1:283,2\n196#1:285,2\n141#1:273,4\n146#1:277,4\n*E\n"})
public final class BetterModelPluginImpl
extends JavaPlugin
implements BetterModelPlugin {
    @NotNull
    private final MinecraftVersion version;
    private NMS nms;
    @NotNull
    private final AtomicBoolean onReload;
    @NotNull
    private final Lazy managers$delegate;
    @NotNull
    private final ModelScheduler scheduler;
    @NotNull
    private final Lazy evaluator$delegate;
    @NotNull
    private final log.1 log;
    @NotNull
    private final Semver semver;
    @NotNull
    private final Lazy attributes$delegate;
    @NotNull
    private final Lazy snapshot$delegate;
    @Nullable
    private Metrics _metrics;
    @NotNull
    private BetterModelConfigImpl _config;
    @NotNull
    private Function1<? super PackZipper, Unit> reloadStartTask;
    @NotNull
    private Function1<? super BetterModelPlugin.ReloadResult, Unit> reloadEndTask;

    public BetterModelPluginImpl() {
        String string = Bukkit.getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        this.version = new MinecraftVersion(StringsKt.substringBefore$default(string, '-', null, 2, null));
        this.onReload = new AtomicBoolean();
        this.managers$delegate = LazyKt.lazy(BetterModelPluginImpl::managers_delegate$lambda$0);
        this.scheduler = BetterModel.IS_FOLIA ? (ModelScheduler)new PaperScheduler() : (ModelScheduler)new BukkitScheduler();
        this.evaluator$delegate = LazyKt.lazy(BetterModelPluginImpl::evaluator_delegate$lambda$1);
        this.log = new BetterModelLogger(this){
            private final Logger internalLogger;
            {
                Logger logger = $receiver.getLogger();
                Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
                this.internalLogger = logger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void info(String ... message) {
                Intrinsics.checkNotNullParameter(message, "message");
                Logger logger = this.internalLogger;
                synchronized (logger) {
                    boolean bl = false;
                    for (String s : message) {
                        this.internalLogger.info(s);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void warn(String ... message) {
                Intrinsics.checkNotNullParameter(message, "message");
                Logger logger = this.internalLogger;
                synchronized (logger) {
                    boolean bl = false;
                    for (String s : message) {
                        this.internalLogger.warning(s);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this.semver = new Semver(this.getDescription().getVersion(), Semver.SemverType.LOOSE);
        this.attributes$delegate = LazyKt.lazy(() -> BetterModelPluginImpl.attributes_delegate$lambda$4(this));
        this.snapshot$delegate = LazyKt.lazy(() -> BetterModelPluginImpl.snapshot_delegate$lambda$7(this));
        this._config = new BetterModelConfigImpl((ConfigurationSection)new MemoryConfiguration());
        this.reloadStartTask = BetterModelPluginImpl::reloadStartTask$lambda$9;
        this.reloadEndTask = BetterModelPluginImpl::reloadEndTask$lambda$10;
    }

    private final List<GlobalManager> getManagers() {
        Lazy lazy = this.managers$delegate;
        return (List)lazy.getValue();
    }

    private final BetterModelEvaluatorImpl getEvaluator() {
        Lazy lazy = this.evaluator$delegate;
        return (BetterModelEvaluatorImpl)lazy.getValue();
    }

    private static /* synthetic */ void getSemver$annotations() {
    }

    @NotNull
    public final Attributes getAttributes() {
        Lazy lazy = this.attributes$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Attributes)t;
    }

    private final int getSnapshot() {
        Lazy lazy = this.snapshot$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final BetterModelConfigImpl getConfig() {
        return this._config;
    }

    /*
     * WARNING - void declaration
     */
    private final void setConfig(BetterModelConfigImpl value) {
        void $this$_set_config__u24lambda_u248;
        BetterModelConfigImpl betterModelConfigImpl;
        BetterModelConfigImpl betterModelConfigImpl2 = betterModelConfigImpl = value;
        BetterModelPluginImpl betterModelPluginImpl = this;
        boolean bl = false;
        if ($this$_set_config__u24lambda_u248.metrics()) {
            if (this._metrics == null) {
                this._metrics = new Metrics(this, 24237);
            }
        } else {
            Metrics metrics = this._metrics;
            if (metrics != null) {
                metrics.shutdown();
            }
            this._metrics = null;
        }
        betterModelPluginImpl._config = betterModelConfigImpl;
    }

    public void onLoad() {
        BetterModelLibrary.INSTANCE.load$core(this);
        BetterModel.register(this);
        this.setConfig(new BetterModelConfigImpl((ConfigurationSection)PluginConfiguration.CONFIG.create()));
    }

    public void onEnable() {
        BetterModelPlugin.ReloadResult result;
        boolean bl;
        TextComponent.Builder $this$componentOf_u24lambda_u245$iv;
        boolean $i$f$componentOf;
        boolean $i$f$componentOf2;
        String content$iv;
        Collection collection;
        HttpUtil.PluginVersion it;
        NMS nMS;
        MinecraftVersion minecraftVersion = this.version;
        if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_6) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_7) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_8)) {
            nMS = new kr.toxicity.model.nms.v1_21_R5.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_5)) {
            nMS = new kr.toxicity.model.nms.v1_21_R4.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_4)) {
            nMS = new kr.toxicity.model.nms.v1_21_R3.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_2) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_3)) {
            nMS = new NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_21_1)) {
            nMS = new kr.toxicity.model.nms.v1_21_R1.NMSImpl();
        } else if (Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_5) || Intrinsics.areEqual(minecraftVersion, MinecraftVersion.V1_20_6)) {
            nMS = new kr.toxicity.model.nms.v1_20_R4.NMSImpl();
        } else {
            String[] stringArray = new String[]{"Unsupported version: " + this.version, "Plugin will be automatically disabled."};
            PluginsKt.warn(stringArray);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.nms = nMS;
        Iterable $this$forEach$iv = this.getManagers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalManager p0 = (GlobalManager)element$iv;
            boolean bl2 = false;
            p0.start();
        }
        HttpUtil.LatestVersion latestVersion = HttpUtil.versionList();
        Intrinsics.checkNotNullExpressionValue(latestVersion, "versionList(...)");
        HttpUtil.LatestVersion latestVersion2 = latestVersion;
        ArrayList<Component> versionNoticeList = new ArrayList<Component>();
        HttpUtil.PluginVersion pluginVersion = latestVersion2.release();
        if (pluginVersion != null) {
            it = pluginVersion;
            boolean bl3 = false;
            if (this.semver.compareTo(it.versionNumber()) < 0) {
                collection = versionNoticeList;
                content$iv = "New BetterModel release found: ";
                $i$f$componentOf2 = false;
                $i$f$componentOf = false;
                $this$componentOf_u24lambda_u245$iv = SendersKt.componentOf();
                bl = false;
                TextComponent.Builder builder = $this$componentOf_u24lambda_u245$iv.content(content$iv);
                Intrinsics.checkNotNullExpressionValue(builder, "content(...)");
                TextComponent.Builder $this$onEnable_u24lambda_u2412_u24lambda_u2411 = builder;
                boolean bl4 = false;
                ComponentBuilder componentBuilder = $this$onEnable_u24lambda_u2412_u24lambda_u2411.append(it.toURLComponent());
                Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
                BuildableComponent buildableComponent = ((TextComponent.Builder)componentBuilder).build();
                Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
                content$iv = (TextComponent)buildableComponent;
                collection.add(content$iv);
            }
        }
        HttpUtil.PluginVersion pluginVersion2 = latestVersion2.snapshot();
        if (pluginVersion2 != null) {
            it = pluginVersion2;
            boolean bl5 = false;
            if (this.semver.compareTo(it.versionNumber()) < 0) {
                collection = versionNoticeList;
                content$iv = "New BetterModel snapshot found: ";
                $i$f$componentOf2 = false;
                $i$f$componentOf = false;
                $this$componentOf_u24lambda_u245$iv = SendersKt.componentOf();
                bl = false;
                TextComponent.Builder builder = $this$componentOf_u24lambda_u245$iv.content(content$iv);
                Intrinsics.checkNotNullExpressionValue(builder, "content(...)");
                TextComponent.Builder $this$onEnable_u24lambda_u2414_u24lambda_u2413 = builder;
                boolean bl6 = false;
                ComponentBuilder componentBuilder = $this$onEnable_u24lambda_u2414_u24lambda_u2413.append(it.toURLComponent());
                Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
                BuildableComponent buildableComponent = ((TextComponent.Builder)componentBuilder).build();
                Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
                TextComponent textComponent = (TextComponent)buildableComponent;
                collection.add(textComponent);
            }
        }
        if (!((Collection)versionNoticeList).isEmpty()) {
            EventsKt.registerListener(new Listener(this, versionNoticeList){
                final /* synthetic */ BetterModelPluginImpl this$0;
                final /* synthetic */ ArrayList<Component> $versionNoticeList;
                {
                    this.this$0 = $receiver;
                    this.$versionNoticeList = $versionNoticeList;
                }

                @EventHandler
                public final void join(PlayerJoinEvent $this$join) {
                    Intrinsics.checkNotNullParameter($this$join, "<this>");
                    if (!$this$join.getPlayer().isOp() || !BetterModelPluginImpl.access$getConfig(this.this$0).versionCheck()) {
                        return;
                    }
                    Player player = $this$join.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                    Audience audience = SendersKt.audience((CommandSender)player);
                    ArrayList<Component> arrayList = this.$versionNoticeList;
                    Audience $this$join_u24lambda_u240 = audience;
                    boolean bl = false;
                    Iterable $this$forEach$iv = arrayList;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ComponentLike p0 = (ComponentLike)element$iv;
                        boolean bl2 = false;
                        SendersKt.info($this$join_u24lambda_u240, p0);
                    }
                }
            });
        }
        if (this.isSnapshot()) {
            String[] stringArray = new String[]{"This build is dev version: be careful to use it!", "Build number: " + this.getSnapshot()};
            PluginsKt.warn(stringArray);
        }
        if ((result = this.reload(new ReloadInfo(true, (CommandSender)Bukkit.getConsoleSender()))) instanceof BetterModelPlugin.ReloadResult.Failure) {
            Throwable throwable = ((BetterModelPlugin.ReloadResult.Failure)result).throwable();
            Intrinsics.checkNotNullExpressionValue(throwable, "throwable(...)");
            PluginsKt.handleException(throwable, "Unable to load plugin properly.");
        } else {
            if (result instanceof BetterModelPlugin.ReloadResult.OnReload) {
                throw new RuntimeException("Plugin load failed.");
            }
            if (result instanceof BetterModelPlugin.ReloadResult.Success) {
                String[] stringArray = new String[3];
                stringArray[0] = "Plugin is loaded. (" + FunctionsKt.withComma(((BetterModelPlugin.ReloadResult.Success)result).totalTime()) + " ms)";
                NMS nMS2 = this.nms;
                if (nMS2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("nms");
                    nMS2 = null;
                }
                stringArray[1] = "Minecraft version: " + this.version + ", NMS version: " + nMS2.version();
                stringArray[2] = "Platform: " + (BetterModel.IS_FOLIA ? "Folia" : (BetterModel.IS_PURPUR ? "Purpur" : (BetterModel.IS_PAPER ? "Paper" : "Bukkit")));
                PluginsKt.info(stringArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void onDisable() {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            EntityTrackerRegistry entityTrackerRegistry = EntityTrackerRegistry.registry(it.getUniqueId());
            if (entityTrackerRegistry == null) continue;
            entityTrackerRegistry.close();
        }
        BukkitAudiences bukkitAudiences = SendersKt.getADVENTURE_PLATFORM();
        if (bukkitAudiences != null) {
            bukkitAudiences.close();
        }
        $this$forEach$iv = this.getManagers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalManager p0 = (GlobalManager)element$iv;
            boolean bl = false;
            p0.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BetterModelPlugin.ReloadResult reload(@NotNull ReloadInfo info) {
        Object object;
        Object $this$reload_u24lambda_u2421;
        Intrinsics.checkNotNullParameter(info, "info");
        if (!this.onReload.compareAndSet(false, true)) {
            return BetterModelPlugin.ReloadResult.OnReload.INSTANCE;
        }
        Object object2 = this;
        try {
            BetterModelPlugin.ReloadResult.Success success;
            $this$reload_u24lambda_u2421 = object2;
            boolean bl = false;
            if (!info.firstReload()) {
                super.setConfig(new BetterModelConfigImpl((ConfigurationSection)PluginConfiguration.CONFIG.create()));
            }
            PackZipper packZipper = PackZipper.zipper();
            Intrinsics.checkNotNullExpressionValue(packZipper, "zipper(...)");
            Object object3 = packZipper;
            ((BetterModelPluginImpl)$this$reload_u24lambda_u2421).reloadStartTask.invoke((PackZipper)object3);
            PackZipper zipper = object3;
            Set<IndicatorConfig.IndicatorOption> set = super.getConfig().indicator().options();
            Intrinsics.checkNotNullExpressionValue(set, "options(...)");
            object3 = new ReloadPipeline(IndicatorsKt.toIndicator((Iterable<? extends IndicatorConfig.IndicatorOption>)set, info));
            Throwable throwable = null;
            try {
                PackResult packResult;
                Object it;
                ReloadPipeline pipeline = (ReloadPipeline)object3;
                boolean bl2 = false;
                long time = System.currentTimeMillis();
                Iterable $this$forEach$iv = super.getManagers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (GlobalManager)element$iv;
                    boolean bl3 = false;
                    it.reload(pipeline, zipper);
                }
                pipeline.setStatus("Generating files...");
                pipeline.goal(zipper.size());
                BetterModelConfig.PackType packType = PluginsKt.getCONFIG().packType();
                Intrinsics.checkNotNullExpressionValue((Object)packType, "packType(...)");
                PackGenerator $this$reload_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419 = PacksKt.toGenerator(packType);
                boolean bl4 = false;
                long l = System.currentTimeMillis() - time;
                if ($this$reload_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getExists() && info.firstReload()) {
                    void $this$reload_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418;
                    PackResult packResult2 = new PackResult(zipper.build().meta(), null);
                    it = packResult2;
                    long l2 = l;
                    boolean bl5 = false;
                    $this$reload_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.freeze();
                    Unit unit = Unit.INSTANCE;
                    l = l2;
                    packResult = packResult2;
                } else {
                    packResult = $this$reload_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.create(zipper, pipeline);
                }
                PackResult packResult3 = packResult;
                long l3 = l;
                success = new BetterModelPlugin.ReloadResult.Success(l3, packResult3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object3, throwable);
            }
            $this$reload_u24lambda_u2421 = Result.constructor-impl(success);
        }
        catch (Throwable bl) {
            $this$reload_u24lambda_u2421 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$reload_u24lambda_u2421;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = new BetterModelPlugin.ReloadResult.Failure(it);
        }
        Object $this$reload_u24lambda_u2423 = object2 = object;
        boolean bl = false;
        this.onReload.set(false);
        this.reloadEndTask.invoke((BetterModelPlugin.ReloadResult)object2);
        return (BetterModelPlugin.ReloadResult)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAssets(@NotNull ReloadPipeline pipeline, @NotNull String prefix, @NotNull Function2<? super String, ? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter(pipeline, "pipeline");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        Closeable closeable = new JarFile(this.getFile());
        Throwable throwable = null;
        try {
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = it.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            pipeline.forEachParallel(SequencesKt.toList(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), arg_0 -> BetterModelPluginImpl.loadAssets$lambda$27$lambda$24(prefix, arg_0))), loadAssets.1.2.INSTANCE, arg_0 -> BetterModelPluginImpl.loadAssets$lambda$27$lambda$26(it, consumer, prefix, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    @NotNull
    public BetterModelLogger logger() {
        return this.log;
    }

    @Override
    @NotNull
    public ModelScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public BetterModelEvaluator evaluator() {
        return this.getEvaluator();
    }

    @Override
    @NotNull
    public ModelManager modelManager() {
        return ModelManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public PlayerManager playerManager() {
        return PlayerManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public EntityManager entityManager() {
        return EntityManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public CommandManager commandManager() {
        return CommandManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public CompatibilityManager compatibilityManager() {
        return CompatibilityManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public ScriptManager scriptManager() {
        return ScriptManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public SkinManager skinManager() {
        return SkinManagerImpl.INSTANCE;
    }

    @Override
    @NotNull
    public BetterModelConfig config() {
        return this.getConfig();
    }

    @Override
    @NotNull
    public MinecraftVersion version() {
        return this.version;
    }

    @Override
    @NotNull
    public Semver semver() {
        return this.semver;
    }

    @Override
    @NotNull
    public NMS nms() {
        NMS nMS = this.nms;
        if (nMS == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nms");
            nMS = null;
        }
        return nMS;
    }

    @Override
    public boolean isSnapshot() {
        return this.getSnapshot() > 0;
    }

    @Override
    public synchronized void addReloadStartHandler(@NotNull Consumer<PackZipper> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        Function1<? super PackZipper, Unit> previous = this.reloadStartTask;
        this.reloadStartTask = arg_0 -> BetterModelPluginImpl.addReloadStartHandler$lambda$28(previous, consumer, arg_0);
    }

    @Override
    public synchronized void addReloadEndHandler(@NotNull Consumer<BetterModelPlugin.ReloadResult> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        Function1<? super BetterModelPlugin.ReloadResult, Unit> previous = this.reloadEndTask;
        this.reloadEndTask = arg_0 -> BetterModelPluginImpl.addReloadEndHandler$lambda$29(previous, consumer, arg_0);
    }

    private static final List managers_delegate$lambda$0() {
        GlobalManager[] globalManagerArray = new GlobalManager[]{CompatibilityManagerImpl.INSTANCE, SkinManagerImpl.INSTANCE, ModelManagerImpl.INSTANCE, PlayerManagerImpl.INSTANCE, EntityManagerImpl.INSTANCE, ScriptManagerImpl.INSTANCE, CommandManagerImpl.INSTANCE};
        return CollectionsKt.listOf(globalManagerArray);
    }

    private static final BetterModelEvaluatorImpl evaluator_delegate$lambda$1() {
        return new BetterModelEvaluatorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Attributes attributes_delegate$lambda$4(BetterModelPluginImpl this$0) {
        Attributes attributes;
        Closeable closeable = new JarFile(this$0.getFile());
        Throwable throwable = null;
        try {
            Attributes attributes2;
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            Closeable closeable2 = it.getInputStream(new ZipEntry("META-INF/MANIFEST.MF"));
            Throwable throwable2 = null;
            try {
                InputStream stream = (InputStream)closeable2;
                boolean bl2 = false;
                attributes2 = new Manifest(stream).getMainAttributes();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            attributes = attributes2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return attributes;
    }

    private static final int snapshot_delegate$lambda$7(BetterModelPluginImpl this$0) {
        Object object;
        Object $this$snapshot_delegate_u24lambda_u247_u24lambda_u245;
        Object object2 = this$0;
        try {
            $this$snapshot_delegate_u24lambda_u247_u24lambda_u245 = object2;
            boolean bl = false;
            String string = ((BetterModelPluginImpl)$this$snapshot_delegate_u24lambda_u247_u24lambda_u245).getAttributes().getValue("Dev-Build");
            Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
            $this$snapshot_delegate_u24lambda_u247_u24lambda_u245 = Result.constructor-impl(Integer.parseInt(string));
        }
        catch (Throwable bl) {
            $this$snapshot_delegate_u24lambda_u247_u24lambda_u245 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$snapshot_delegate_u24lambda_u247_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            PluginsKt.handleException(it, "Unable to parse manifest's build data");
            object = -1;
        }
        return ((Number)object).intValue();
    }

    private static final Unit reloadStartTask$lambda$9(PackZipper it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit reloadEndTask$lambda$10(BetterModelPlugin.ReloadResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final boolean loadAssets$lambda$27$lambda$24(String $prefix, JarEntry entry) {
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.startsWith$default(string, $prefix, false, 2, null) && entry.getName().length() > $prefix.length() + 1 && !entry.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit loadAssets$lambda$27$lambda$26(JarFile $it, Function2 $consumer, String $prefix, JarEntry entry) {
        InputStream inputStream = $it.getInputStream(entry);
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = string;
            int n2 = $prefix.length() + 1;
            String string3 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            $consumer.invoke(string3, stream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addReloadStartHandler$lambda$28(Function1 $previous, Consumer $consumer, PackZipper it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $previous.invoke(it);
        $consumer.accept(it);
        return Unit.INSTANCE;
    }

    private static final Unit addReloadEndHandler$lambda$29(Function1 $previous, Consumer $consumer, BetterModelPlugin.ReloadResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $previous.invoke(it);
        $consumer.accept(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ BetterModelConfigImpl access$getConfig(BetterModelPluginImpl $this) {
        return $this.getConfig();
    }
}

