/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AnimationEventHandler {
    private final AtomicBoolean isStateCreated = new AtomicBoolean();
    private final AtomicBoolean isStateRemoved = new AtomicBoolean();
    private final AtomicBoolean isAnimationRemoved = new AtomicBoolean();
    private Consumer<UUID> stateCreated;
    private Consumer<UUID> stateRemoved;
    private Runnable onAnimationRemove;

    @NotNull
    public static AnimationEventHandler start() {
        return new AnimationEventHandler();
    }

    @ApiStatus.Internal
    public void stateCreated(@NotNull UUID uuid) {
        if (this.stateCreated == null) {
            return;
        }
        if (this.isStateCreated.compareAndSet(false, true)) {
            this.stateCreated.accept(uuid);
        }
    }

    @ApiStatus.Internal
    public void stateRemoved(@NotNull UUID uuid) {
        if (this.stateRemoved == null) {
            return;
        }
        if (this.isStateRemoved.compareAndSet(false, true)) {
            this.stateRemoved.accept(uuid);
        }
    }

    @ApiStatus.Internal
    public void animationRemove() {
        if (this.onAnimationRemove == null) {
            return;
        }
        if (this.isAnimationRemoved.compareAndSet(false, true)) {
            this.onAnimationRemove.run();
        }
    }

    @NotNull
    public AnimationEventHandler onAnimationRemove(@NotNull Runnable runnable) {
        if (this.onAnimationRemove == null) {
            this.onAnimationRemove = runnable;
        } else {
            Runnable previous = this.onAnimationRemove;
            this.onAnimationRemove = () -> {
                previous.run();
                runnable.run();
            };
        }
        return this;
    }

    @NotNull
    public AnimationEventHandler onStateCreated(@NotNull Consumer<UUID> consumer) {
        this.stateCreated = this.stateCreated == null ? consumer : this.stateCreated.andThen(consumer);
        return this;
    }

    @NotNull
    public AnimationEventHandler onStateRemoved(@NotNull Consumer<UUID> consumer) {
        this.stateRemoved = this.stateRemoved == null ? consumer : this.stateRemoved.andThen(consumer);
        return this;
    }
}

