/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public record ModelBlueprint(@NotNull String name, float scale, @NotNull ModelResolution resolution, @NotNull List<BlueprintTexture> textures, @NotNull List<BlueprintChildren> group, @NotNull Map<String, BlueprintAnimation> animations) {
    public boolean hasTexture() {
        return this.textures.stream().anyMatch(BlueprintTexture::canBeRendered);
    }

    @NotNull
    public @Unmodifiable Stream<BlueprintImage> buildImage() {
        return this.textures.stream().filter(BlueprintTexture::canBeRendered).map(texture -> new BlueprintImage(PackUtil.toPackName(this.name + "_" + texture.name()), texture.image(), texture.isAnimatedTexture() ? texture.toMcmeta() : null));
    }
}

