/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.AnimationGenerator;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelAnimation(@NotNull String name, @Nullable AnimationIterator.Type loop, boolean override, @NotNull String uuid, float length, @Nullable Map<String, ModelAnimator> animators) {
    @Nullable
    private final AnimationIterator.Type loop;
    @Nullable
    private final Map<String, ModelAnimator> animators;

    @NotNull
    public BlueprintAnimation toBlueprint(@NotNull List<BlueprintChildren> children, @NotNull ModelPlaceholder placeholder) {
        HashMap<BoneName, BlueprintAnimator.AnimatorData> map = new HashMap<BoneName, BlueprintAnimator.AnimatorData>();
        BlueprintScript blueprintScript = BlueprintScript.fromEmpty(this);
        Map<String, ModelAnimator> animator = this.animators();
        for (Map.Entry<String, ModelAnimator> entry : animator.entrySet()) {
            String name = entry.getValue().name();
            if (name == null) continue;
            if (entry.getKey().equals("effects")) {
                blueprintScript = this.toScript(entry.getValue());
                continue;
            }
            BlueprintAnimator.Builder builder = new BlueprintAnimator.Builder(this.length());
            entry.getValue().keyframes().stream().sorted(Comparator.naturalOrder()).forEach(keyframe -> builder.addFrame((ModelKeyframe)keyframe, placeholder));
            map.put(BoneTagRegistry.parse(name), builder.build(name));
        }
        Map<BoneName, BlueprintAnimator> animators = AnimationGenerator.createMovements(this.length(), children, map);
        return new BlueprintAnimation(this.name(), this.loop(), this.length(), this.override(), animators, blueprintScript, animators.isEmpty() ? List.of(AnimationMovement.EMPTY, new AnimationMovement(this.length())) : animators.values().iterator().next().keyFrame().stream().map(a -> new AnimationMovement(a.time())).toList());
    }

    @NotNull
    private BlueprintScript toScript(@NotNull ModelAnimator animator) {
        List<TimeScript> get = animator.keyframes().stream().map(d -> AnimationScript.of(d.dataPoints().stream().map(Datapoint::script).filter(Objects::nonNull).map(raw -> BetterModel.plugin().scriptManager().build((String)raw)).filter(Objects::nonNull).toList()).time(d.time())).toList();
        ArrayList<TimeScript> list = new ArrayList<TimeScript>(get.size() + 2);
        if (get.getFirst().time() > 0.0f) {
            list.add(TimeScript.EMPTY);
        }
        float before = 0.0f;
        for (TimeScript timeScript : get) {
            float t = timeScript.time();
            list.add(timeScript.time(InterpolationUtil.roundTime(t - before)));
            before = t;
        }
        float len = this.length() - before;
        if (len > 0.0f) {
            list.add(AnimationScript.EMPTY.time(len));
        }
        return new BlueprintScript(this.name(), this.loop(), this.length(), list);
    }

    @NotNull
    public AnimationIterator.Type loop() {
        return this.loop != null ? this.loop : AnimationIterator.Type.PLAY_ONCE;
    }

    @NotNull
    public Map<String, ModelAnimator> animators() {
        return this.animators != null ? this.animators : Collections.emptyMap();
    }
}

