/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.Float4;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelData(@NotNull ModelResolution resolution, @NotNull List<ModelElement> elements, @NotNull List<ModelChildren> outliner, @NotNull List<ModelTexture> textures, @Nullable List<ModelAnimation> animations, @SerializedName(value="animation_variable_placeholders") @Nullable ModelPlaceholder placeholder) {
    @Nullable
    private final List<ModelAnimation> animations;
    @SerializedName(value="animation_variable_placeholders")
    @Nullable
    private final ModelPlaceholder placeholder;
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Float3.class, Float3.PARSER).registerTypeAdapter(Float4.class, Float4.PARSER).registerTypeAdapter(Datapoint.class, Datapoint.PARSER).registerTypeAdapter(ModelChildren.class, ModelChildren.PARSER).registerTypeAdapter(ModelPlaceholder.class, ModelPlaceholder.PARSER).create();

    @NotNull
    public ModelBlueprint toBlueprint(@NotNull String name) {
        ModelPlaceholder placeholder = this.placeholder();
        Map<String, ModelElement> elementMap = CollectionUtil.associate(this.elements(), ModelElement::uuid);
        List<BlueprintChildren> group = CollectionUtil.mapToList(this.outliner(), children -> children.toBlueprint(elementMap));
        return new ModelBlueprint(name, this.scale(), this.resolution(), CollectionUtil.mapToList(this.textures(), ModelTexture::toBlueprint), group, CollectionUtil.associate(this.animations().stream().map(raw -> raw.toBlueprint(group, placeholder)), BlueprintAnimation::name));
    }

    public boolean isSupported() {
        return this.elements().stream().allMatch(ModelElement::isSupported);
    }

    public float scale() {
        return (float)this.elements().stream().mapToDouble(ModelElement::max).max().orElse(16.0) / 16.0f;
    }

    @NotNull
    public ModelPlaceholder placeholder() {
        return this.placeholder != null ? this.placeholder : ModelPlaceholder.EMPTY;
    }

    @NotNull
    public List<ModelAnimation> animations() {
        return this.animations != null ? this.animations : Collections.emptyList();
    }
}

