/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record ModelTexture(@NotNull String name, @NotNull String source, int width, int height, @SerializedName(value="uv_width") int uvWidth, @SerializedName(value="uv_height") int uvHeight) {
    @NotNull
    public BlueprintTexture toBlueprint() {
        BufferedImage image;
        try (ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(this.source().split(",")[1]));){
            image = ImageIO.read(input);
        }
        catch (Exception e) {
            throw new RuntimeException("image");
        }
        return new BlueprintTexture(this.name().split("\\.")[0], image, this.uvWidth(), this.uvHeight());
    }
}

